// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: CxFetch.hh
//   Context for fetch.
//   This is a reference class.
//
// File Created:	22 Oct 1995		Michael Chastain
// Last Edited:		16 Nov 1995		Michael Chastain

#if !defined(CX_FETCH_HH)
#define CX_FETCH_HH

#include <ErPtr.hh>
#include <EvSci.hh>
#include <EvSco.hh>
#include <PrDir.hh>
#include <PrMap.hh>
#include <PrProc.hh>



class	CxFetch
{
    // Life cycle methods.
    public:
				CxFetch		( PrProc * &	   );
				~CxFetch	(		   );

    // Forbidden copiers.
    private:
				CxFetch		( const CxFetch &  );
	void			operator =	( const CxFetch &  );

    // Mutator.
    public:
	void			setPtr		( const EvSci *,
						  const EvSco *    );

    // Component accessors.
    public:
	const PrProc &		getProc		(		   ) const;
	PrProc &		getProc		(		   );
	const PrMap &		getMap		(		   ) const;
	PrMap &			getMap		(		   );
	const PrDir &		getDir		(		   ) const;
	PrDir &			getDir		(		   );
	const EvSci &		getEvSci	(		   ) const;
	const EvSco &		getEvSco	(		   ) const;
	int			nextSeqDs	(		   );

    // Instance data.
    private:
	PrProc *		pproc_;		// Process.
	PrMap			map_;		// Memory map.
	PrDir			dir_;		// Directory tracker.
	const EvSci *		pevSciArg_;	// Most recent EvSci.
	const EvSco *		pevScoScr_;	// This EvSco.
	int			iseqDs_;	// Dataset sequence number.
};



// Inline methods.

inline void CxFetch::setPtr( const EvSci * pevSciArg, const EvSco * pevScoScr )
{
    pevSciArg_ = pevSciArg;
    pevScoScr_ = pevScoScr;
}

inline const PrProc & CxFetch::getProc( ) const
{
    return *pproc_;
}

inline PrProc & CxFetch::getProc( )
{
    return *pproc_;
}

inline const PrMap & CxFetch::getMap( ) const
{
    return map_;
}

inline PrMap & CxFetch::getMap( )
{
    return map_;
}

inline const PrDir & CxFetch::getDir( ) const
{
    return dir_;
}

inline PrDir & CxFetch::getDir( )
{
    return dir_;
}

inline const EvSci & CxFetch::getEvSci( ) const
{
    if ( pevSciArg_ == 0 )
	ErPtr( );
    return *pevSciArg_;
}

inline const EvSco & CxFetch::getEvSco( ) const
{
    if ( pevScoScr_ == 0 )
	ErPtr( );
    return *pevScoScr_;
}

inline int CxFetch::nextSeqDs( )
{
    return iseqDs_++;
}



#endif
