// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlState.hh
//   State of controlled process.
//   This is an enum.
//
// File Created:	31 Oct 1995		Michael Chastain
// Last Edited:		17 Nov 1995		Michael Chastain

#if !defined(CONTROL_STATE_HH)
#define CONTROL_STATE_HH



// Viewer -> Execer -> Replay

enum	StTrack
{
	stTrackViewer,		// Viewer.
	stTrackExecer,		// Exec'er.
	stTrackReplay		// Under replay control.
};



// Running -> Runnable -> Running
// Running -> Waiting  -> Runnable -> Running
// Running -> Stopped  -> Ready    -> Runnable   -> Running
// Running -> Waiting  -> Stopped  -> Ready      -> Runnable   -> Running
// Running -> Exited   -> Dead     -> DESTRUCTOR

enum	StRun
{
	stRunRunning,		// Running.
	stRunRunnable,		// Runnable:	keep running.
	stRunWaiting,		// Waiting:	child must stop.
	stRunStopped,		// Stopped:	parent must wait.
	stRunReady,		// Ready:	parent must ptrace.
	stRunExited,		// Exited:	parent must wait.
	stRunDead		// Dead:	transient post-exit.
};

#endif
