// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlReplay.cc
//   Event filter.
//
// File Created:	12 Nov 1995		Michael Chastain
// Last Edited:		19 Nov 1995		Michael Chastain

#include <CxStore.hh>
#include <ErAbort.hh>
#include <ErFatal.hh>
#include <EvBase.hh>
#include <EvLog.hh>
#include <EvType.hh>
#include <MmType.hh>
#include <PrProc.hh>

#include <ControlReplay.hh>



// Replay, after wait.
void replay_aw( CxStore & cxReplay, WhLap <CxStore> & )
{
    // Get process and event type.
    PrProc & procReplay = cxReplay.getProc( );
    const TyEvent tyEvent = procReplay.getTyEvent( );

    // Set continuation address.
    switch ( tyEvent )
    {
    default:
	ErAbort( "replay_aw: bad enum." );

    case tyEvBpt:
	cxReplay.setAddrCont( MmAddr( procReplay.fetchRegPc( ) ) - sizeof(MmInsn) );
	break;

    case tyEvExit:
	cxReplay.setAddrCont( 0 );
	break;

    case tyEvStep:
    case tyEvBlank:
    case tyEvFirst:
    case tyEvSci:
    case tyEvExec:
    case tyEvSco:
    case tyEvSignal:
	cxReplay.setAddrCont( MmAddr( procReplay.fetchRegPc( ) ) );
	break;
    }

    // Store from log.
    switch ( tyEvent )
    {
    default:
	ErAbort( "replay_aw: bad enum." );

    case tyEvBpt:
    case tyEvStep:
	break;

    case tyEvBlank:
    case tyEvFirst:
    case tyEvSci:
    case tyEvExec:
    case tyEvSco:
    case tyEvExit:
    case tyEvSignal:
	{
	    cxReplay.getLog( ).advance( );
	    const EvBase & evReplay = cxReplay.getLog( ).getEvCur( );
	    if ( evReplay.isModelFail( ) )
		ErFatal( "replay_aw: cannot replay." );
	    evReplay.storeAw( cxReplay );
	}
	break;
    }
}	



// Replay, before continue.
void replay_bc( CxStore & cxReplay, WhLap <CxStore> & )
{
    // Check continuation address.
    if ( MmAddr( cxReplay.getProc( ).fetchRegPc( ) ) != cxReplay.getAddrCont( ) )
	ErFatal( "replay_bc: pc mismatch." );

    // Store from log.
    switch ( cxReplay.getProc( ).getTyEvent( ) )
    {
    default:
	ErAbort( "replay_bc: bad enum." );

    case tyEvBpt:
    case tyEvStep:
	break;

    case tyEvBlank:
    case tyEvFirst:
    case tyEvSci:
    case tyEvExec:
    case tyEvSco:
    case tyEvExit:
    case tyEvSignal:
	{
	    const EvBase & evReplay = cxReplay.getLog( ).getEvCur( );
	    if ( evReplay.isModelFail( ) )
		ErFatal( "replay_bc: cannot replay." );
	    evReplay.storeBc( cxReplay );
	}
	break;
    }
}    
