// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlExecerLix.cc
//   Event filter.
//
// File Created:	31 Oct 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain

#include <linux/unistd.h>

#include <CxStore.hh>
#include <EvBase.hh>
#include <EvLog.hh>
#include <EvSco.hh>
#include <MmScr.hh>
#include <MmSeg.hh>
#include <MmType.hh>
#include <PrProc.hh>
#include <TySegLix.hh>
#include <WhFlatOut.hh>

#include <ControlExecer.hh>
#include <ControlState.hh>



// Local functions.
void	execer_execve_sci_bc	( CxStore &, WhLap <CxStore> & );
void	execer_execve_sco_aw	( CxStore &, WhLap <CxStore> & );
void	execer_read_sci_bc	( CxStore &, WhLap <CxStore> & );
void	execer_read_sco_aw	( CxStore &, WhLap <CxStore> & );



// Execer, before continue.
void execer_bc( CxStore & cxExecer, WhLap <CxStore> & lcxControl )
{
    PrProc & procExecer = cxExecer.getProc( );
 
    if ( procExecer.getTyEvent( ) == tyEvSci )
    {
	switch ( procExecer.getSysEntry( ) )
	{
	default:           break;
	case __NR_execve:  execer_execve_sci_bc ( cxExecer, lcxControl ); break;
	case __NR_read:    execer_read_sci_bc   ( cxExecer, lcxControl ); break;
	}
    }
}



// Execer, after wait.
void execer_aw( CxStore & cxExecer, WhLap <CxStore> & lcxControl )
{
    PrProc & procExecer = cxExecer.getProc( );
 
    if ( procExecer.getTyEvent( ) == tyEvSco )
    {
	switch ( procExecer.getSysEntry( ) )
	{
	default:           break;
	case __NR_execve:  execer_execve_sco_aw ( cxExecer, lcxControl ); break;
	case __NR_read:    execer_read_sco_aw   ( cxExecer, lcxControl ); break;
	}
    }
}



// Execer, 'execve', sci, before continue.
void execer_execve_sci_bc( CxStore & cxExecer, WhLap <CxStore> & lcxControl )
{
    // Seek to first successful exec.
    EvLog & logExecer = cxExecer.getLog( );
    logExecer.seekExecFirst( );

    // Stash datasets.
    const EvSco * pevScoExec = logExecer.getEvScoNext( );
    if ( pevScoExec != 0 )
    {
	for ( int ids = 0; ids < pevScoExec->countDs( ); ++ids )
	{
	    cxExecer.getStashLink( ).stashLink( pevScoExec->getDs( ids ),
		cxExecer.getStashData( ) );
	}
    }

    // State transition.
    cxExecer.setTrackState( stTrackReplay );
}



// Execer, 'execve', sco, after wait.
void execer_execve_sco_aw( CxStore & cxExecer, WhLap <CxStore> & )
{
    MmScr scrExecer( MmScr::tyScrInt );
    scrExecer.fetchProc( cxExecer.getProc( ) );
    if ( !scrExecer.isError( ) )
    {
	cxExecer.getBpt( ).clear( );
    }
}



// Execer, 'read', sci, before continue.
void execer_read_sci_bc( CxStore & cxExecer, WhLap <CxStore> & lcxControl )
{
    WhList <MmWord> lwArgSci;
    WhLap  <MmSeg>  lsegSci;
    cxExecer.getProc( ).fetchListReg( 0, 3, lwArgSci );
    cxExecer.setSci( lwArgSci, lsegSci );
}



// Execer, 'read', sco, after wait.
void execer_read_sco_aw( CxStore & cxExecer, WhLap <CxStore> & )
{
    // Get arguments.
    const MmWord wfd = cxExecer.getArgSci( 0 );
    const MmWord wpc = cxExecer.getArgSci( 1 );
    const MmWord wnc = cxExecer.getArgSci( 2 );

    // Magic reads.
    if ( wfd == MmWord( -3 ) || wfd == MmWord( -4 ) )
    {
	// Declare magic flat.
	WhFlatOut flatMagic( 4096 );

	// Put stash name.
	WhString strNameDirStashNul( cxExecer.getStashLink( ).getNameDir( ) );
	strNameDirStashNul.appChrRaw( '\0' );
	flatMagic.putString( strNameDirStashNul );

	// Grab event before first successful exec.
	cxExecer.getLog( ).seekExecFirst( );
	const EvBase & evSciExec = cxExecer.getLog( ).getEvCur( );

	// Put exec name (smashed).
	MmSeg segNameExec( evSciExec.getSeg( 0 ) );
	segNameExec.checkCcs( );
	segNameExec.replaceByte( MmByte( '/' ), MmByte( '%' ) );
	flatMagic.putArrayChar( (const char *) segNameExec.address( ),
	    segNameExec.count( ) );

	// Put arg count.
	const MmSeg & segListArg = evSciExec.getSeg( 1 );
	int nArg = 0;
	if ( segListArg.hasArea( ) && segListArg.hasData( ) )
	{
	    segListArg.checkCountList ( sizeof(MmAddr) );
	    segListArg.checkCountMin  ( sizeof(MmAddr) );
	    nArg = segListArg.count( ) / sizeof(MmAddr) - 1;
	}
	flatMagic.putInt( nArg );

	// Put arg strings.
	for ( int isegArg = 3; isegArg < 3 + nArg; ++isegArg )
	{
	    const MmSeg & segArg = evSciExec.getSeg( isegArg );
	    segArg.checkCcs( );
	    flatMagic.putArrayChar( (const char *) segArg.address( ),
		segArg.count( ) );
	}

	// Put env count.
	const MmSeg & segListEnv = evSciExec.getSeg( 2 );
	int nEnv = 0;
	if ( segListEnv.hasArea( ) && segListEnv.hasData( ) )
	{
	    segListEnv.checkCountList ( sizeof(MmAddr) );
	    segListEnv.checkCountMin  ( sizeof(MmAddr) );
	    nEnv = segListEnv.count( ) / sizeof(MmAddr) - 1;
	}
	flatMagic.putInt( nEnv );

	// Put env strings.
	for ( int isegEnv = 3 + nArg; isegEnv < 3 + nArg + nEnv; ++isegEnv )
	{
	    const MmSeg & segEnv = evSciExec.getSeg( isegEnv );
	    segEnv.checkCcs( );
	    flatMagic.putArrayChar( (const char *) segEnv.address( ),
		segEnv.count( ) );
	}

	// Store magic flat.
	MmSeg segMagic;
	segMagic.fetchProc( cxExecer.getProc( ), tyMmData, tySegAny,
	    MmAddr( wpc ), int( wnc ) );
	MmScr scrMagic( MmScr::tyScrInt );
	if ( wfd == -3 )
	{
	    const int ncMagic = flatMagic.count( );
	    segMagic.smashData( (const MmByte *) &ncMagic, sizeof(ncMagic) );
	    scrMagic.setValue( sizeof(ncMagic), 0 );
	}
	else
	{
	    segMagic.smashData( (const MmByte *) flatMagic.address( ),
		flatMagic.count( ) );
	    scrMagic.setValue( flatMagic.count( ), 0 );
	}
	segMagic.storeProc( cxExecer.getProc( ) );
	scrMagic.storeProc( cxExecer.getProc( ) );
    }
}
