// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlArg.hh
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Jun 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#if !defined(CONTROL_ARG_HH)
#define CONTROL_ARG_HH

#include <WhString.hh>



class	ControlArg
{
    // Constructor.
    public:
				ControlArg	( const char * []  );

    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	const WhString &	getNameSelf	(		   ) const;
	const WhString &	getNameTrace	(		   ) const;
	int			countArgViewer	(		   ) const;
	const char *		getArgViewer	( int		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	WhString		strNameSelf_;	// Name of self.
	WhString		strNameTrace_;	// Name of trace file.
	const char **		argvViewer_;	// Viewer args.
	int			nargViewer_;	// Viewer args.
};



// Inline methods.

inline bool ControlArg::isError( ) const
{
    return fError_;
}

inline bool ControlArg::hasHelp( ) const
{
    return fHelp_;
}

inline const WhString & ControlArg::getNameSelf( ) const
{
    return strNameSelf_;
}

inline const WhString & ControlArg::getNameTrace( ) const
{
    return strNameTrace_;
}

inline int ControlArg::countArgViewer( ) const
{
    return nargViewer_;
}

inline const char * ControlArg::getArgViewer( int iargViewer ) const
{
    return argvViewer_[iargViewer];
}



#endif
