// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlArg.cc
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Jun 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#include <stdio.h>
#include <string.h>

#include <ErPtr.hh>
#include <ControlArg.hh>



// Constructor.
ControlArg::ControlArg( const char * argv [] )
    : fError_		( false	)
    , fHelp_		( false	)
    , strNameSelf_	(	)
    , strNameTrace_	(	)
    , argvViewer_	( 0	)
    , nargViewer_	( 0	)
{
    // Check arguments.
    if ( argv == 0 )
	ErPtr( );

    // Collect name.
    strNameSelf_.appStrRaw( argv[0] );

    // Collect flags.
    int iargFlag;
    for ( iargFlag = 1; argv[iargFlag] != 0; ++iargFlag )
    {
	// Grab the flag arg.
	const char * pcFlag = argv[iargFlag];

	// Recognize flags.
	if      ( ::strcmp( pcFlag, "--" ) == 0 ) { ++iargFlag; break; }
	else if ( ::strcmp( pcFlag, "-h" ) == 0 ) { fHelp_     = true; }
	else if ( pcFlag[0] == '-' )
	{
	    fError_ = true;
	    return;
	}
	else
	{
	    break;
	}
    }

    // Stop parsing at help.
    if ( fHelp_ )
	return;

    // Pick up viewer.
    const int iargViewer = iargFlag;
    argvViewer_ = argv + iargViewer;
    for ( ; argv[iargFlag] != 0; ++iargFlag )
	;
    --iargFlag;
    nargViewer_ = iargFlag - iargViewer;
    if ( nargViewer_ < 1 )
    {
	fError_ = true;
	return;
    }

    // Pick up trace file.
    strNameTrace_.appStrRaw( argv[iargFlag] );
}



// Show usage.
void ControlArg::showUsage( const char * pcVersion ) const
{
    ::printf(
	"%.*s version %s (" __DATE__ ").\n"
	"Usage: %.*s viewer [viewer-flags ...] trace-file\n"
	"         viewer       viewer program such as 'gdb' or 'strace'\n"
	"         viewer-flags optional flags for viewer\n"
	"         trace-file   file of trace data\n"
	,
	getNameSelf( ).count( ), getNameSelf( ).address( ),
	pcVersion,
	getNameSelf( ).count( ), getNameSelf( ).address( ) );
}
