// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ScLine.h
//   System call line.
//   This is a struct.
//   This is a concrete class.
//
// File Created:	10 Apr 1995		Michael Chastain
// Last Edited:		17 Sep 1995		Michael Chastain

#if !defined(SC_LINE_H)
#define SC_LINE_H

#include <MmRet.h>
#include <MmType.h>
#include <MsLine.h>
#include <PrScr.h>
#include <WhList.h>

class	EvBase;
class	EvSci;
class	EvSco;
class	MmMap;
class	PrProc;
class	PrScr;
class	WhString;



class	ScLine
{
    // Argument location.
    public:
	enum	TyArg
	{
	    tyArgMem,				// Args in memory.
	    tyArgReg				// Args in registers.
	};

    // How to smash.
    public:
	enum	TySmash
	{
	    tySmashCant,			// Cannot smash.
	    tySmashDef,				// Default: r0 = -1.
	    tySmashFile0,			// r0 = filename: execve uselib
	    tySmashMmap,			// Special for mmap.
	    tySmashMpi0,			// r0 = unsigned(-1) >> 1.
	    tySmashNop,				// No operation needed.
	    tySmashPair,			// r0 = -1, r1 = -1.
	    tySmashReplay,			// Must replay with same args.
	    tySmashZero				// r0 = 0.
	};

    // Typedefs for combiners.
    private:
	typedef MmRet		FnFetch		( const PrProc &,
						  const MmMap &,
						  const EvSci &,
						  const EvSco &,
						  EvBase &	   );

    // Initializer.
    public:
	void			initFromSce	( MmWord, MmWord   );

    // String interface.
    public:
	void			fmtStrEvSci	( WhString &,
						  const EvSci &	   ) const;

    // Process interface.
    public:
	MmRet			fetchArg	( const PrProc &,
						  bool &,
						  WhList<MmWord> & ) const;

	MmRet			fetchRegSmash	( const PrProc &,
						  WhList<MmWord> & ) const;

	MmRet			fetchScr	( const PrProc &,
						  PrScr &	   ) const;

	MmRet			fetchSeg	( bool,
						  const PrProc &,
						  const MmMap &,
						  const EvSci &,
						  const EvSco &,
						  EvBase &	   ) const;

	MmRet			smash		( PrProc &,
						  const EvSci &	   );

    // Instance data.
    private:
	const char *		pstrName_;	// Name of syscall.
	bool			fKnown_;	// Syscall is known.
	TyArg			tyArg_;		// Argument location.
	int			iArgArg_;	// Argument location.
	const char *		pstrTyArg_;	// Argument types.
	TySmash			tySmash_;	// How to smash.
	PrScr::TyScr		tyScr_;		// Scr type.
	const MsLine *		plmsLine_;	// List of MsLine's.
	int			nmsLine_;	// # of MsLine's.
	FnFetch *		pfnFetchIn_;	// Fetch segins  (combiner).
	FnFetch *		pfnFetchOut_;	// Fetch segouts (combiner).
};



#endif
