// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: RiLine.h
//   Request ioctl line.
//   This is a struct.
//
// File Created:	18 Oct 1994		Michael Chastain
// Last Edited:		29 Jul 1995		Michael Chastain

#if !defined(RI_LINE_H)
#define RI_LINE_H

#include <MmType.h>
#include <WhList.h>



struct	RiLine
{
    public:
	MmWord			wRequest;	// Ioctl request.
	const char *		pstrRequest;	// Name of request.
	int			itySegIn;	// Ingoing seg, if any.
	int			itySegOut;	// Outcoming seg, if any.
};



void	RiLineGet		( MmWord, WhList <const RiLine *> & );
void	RiLineGetTlx		( MmByte, WhList <const RiLine *> & );
void	RiLineList		( WhList <const RiLine *> &, int );



#endif
