// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MsLine.h
//   Memory segment line.
//   This is a struct.
//   This is a concrete class.
//
// File Created:	29 Jul 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#if !defined(MS_LINE_H)
#define MS_LINE_H

#include <MmRet.h>
#include <MmType.h>

class	EvBase;
class	EvSci;
class	EvSco;
class	MmMap;
class	PrProc;



class	MsLine
{
    // Condition types.
    public:
	enum	TyCond
	{
	    tyCondAlways,			// Always use.
	    tyCondArgEq,			// Arg #N == value.
	    tyCondArgNe,			// Arg #N != value.
	    tyCondNever				// Never use.
	};

    // Address types.
    public:
	enum	TyAddr
	{
	    tyAddrArg				// Address in arg #N.
	};

    // Count types.
    public:
	enum	TyCount
	{
	    tyCountArg,				// Count in arg #N.
	    tyCountOne,				// Count is 1.
	    tyCountMem,				// Count in mem at reg #N.
	    tyCountRet,				// Count in return value.
	};

    // Process interface.
    public:
	MmRet			fetchSeg	( bool,
						  const PrProc &,
						  const MmMap &,
						  const EvSci &,
						  const EvSco &,
						  EvBase &	   ) const;

    // Data table.
    private:
	bool			fIngoing_;	// Seg going into kernel.
	bool			fOutcoming_;	// Seg coming out of kernel.
#if 0
	TyCond			tyCond_;	// Type of condition.
	int			iCond_;		// Index for condition.
	MmWord			wCond_;		// Value for condition.
#endif
	int			itySeg_;	// Type of segment at memory.
	TyAddr			tyAddr_;	// Type of address.
	int			iAddr_;		// Index for address.
	TyCount			tyCount_;	// Type of count.
	int			nCount_;	// Count.
};



#endif
