// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmType.h
//   Target machine types.
//   These are typedefs.
//
// File Created:	16 Apr 1995		Michael Chastain
// Last Edited:		22 Sep 1995		Michael Chastain

#if !defined(MM_TYPE_H)
#define MM_TYPE_H



#if defined(MEC_TARGET_LIX) || defined(MEC_TARGET_SUN)
typedef	char *		MmAddr;
typedef	unsigned char	MmByte;
typedef	long long	MmLoff;
typedef	unsigned short	MmShort;
typedef	unsigned int	MmWord;
static const MmAddr mmAddrMin = MmAddr( 0x00000000 );
static const MmAddr mmAddrMac = MmAddr( 0xFFFFFFFF );

inline MmAddr MmAddrAlign( MmAddr addrData )
{
    return MmAddr( MmWord( addrData ) &~ ( sizeof(MmWord) - 1 ) );
}

inline int MmAddrRem( MmAddr addrData )
{
    return MmWord( addrData ) & ( sizeof(MmWord) - 1 );
}

#endif



#if defined(MEC_TARGET_LIX)
// Linux 1.3.24: see 'asm/a.out.h' and 'asm/processor.h'.
static const MmAddr mmAddrSpMax = MmAddr( 0xC0000000 );
#endif



#endif
