// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmSeg.h
//   Memory segment.
//   This is a concrete class.
//
// File Created:	11 Jun 1994		Michael Chastain
// Last Edited:		29 Jul 1995		Michael Chastain

#if !defined(MM_SEG_H)
#define MM_SEG_H

#include <MmArea.h>
#include <MmFlat.h>
#include <MmRet.h>
#include <MmType.h>
#include <PrProc.h>
#include <WhList.h>
#include <WhString.h>



class	MmSeg
{
    // Constructors.
    public:
				MmSeg		(		   );

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Accessors.
    public:
	const MmByte *		address		(		   ) const;
	int			count		(		   ) const;
	MmAddr			getAddrFirst	(		   ) const;
	MmAddr			getAddrLast	(		   ) const;
	const MmArea &		getArea		(		   ) const;
	int			getItySeg	(		   ) const;
	bool			hasOverlap	( const MmSeg &	   ) const;
	bool			isAreaNew	(		   ) const;
	bool			isBound		(		   ) const;

    // Mutators.
    public:
	void			replaceByte	( MmByte, MmByte   );
	void			setAreaFree	( const MmArea &   );
	void			setAreaNew	( bool		   );

    // Checkers.
    public:
	void			checkCcs	(		   ) const;
	void			checkCountList	( int		   ) const;
	void			checkCountMin	( int		   ) const;
	void			checkCountOne	( int		   ) const;

    // Formatters.
    public:
	void			fmtSeg		( WhString &	   ) const;

    // Process interface.
    public:
	MmRet			fetchProc	( const PrProc &,
						  MmArea::TyArea,
						  int, MmAddr, int );
	MmRet			storeProc	( PrProc &	   ) const;

    // Instance data.
    //   MmAddrAlign( area_.getAddrMin( ) ) <--> &lwData_[0].
    private:
	bool			fBound_;	// Is bound to memory.
	bool			fAreaNew_;	// Area has new space.
	int			itySeg_;	// Type of segment.
	MmArea			area_;		// Address area.
	WhList <MmWord>		lwData_;	// Data in this segment.
};



// Inline methods.

inline bool MmSeg::isAreaNew( ) const
{
    return fAreaNew_;
}

inline bool MmSeg::isBound( ) const
{
    return fBound_;
}

inline const MmArea & MmSeg::getArea( ) const
{
    return area_;
}

inline int MmSeg::getItySeg( ) const
{
    return itySeg_;
}

inline void MmSeg::setAreaNew( bool fAreaNew )
{
    fAreaNew_ = fAreaNew;
}



#endif
