// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmRet.h
//   Return values of Mm classes.
//   This is used by all classes now.
//   This is an enum.
//
// File Created:	01 Aug 1994		Michael Chastain
// Last Edited:		02 Jul 1995		Michael Chastain

#if !defined(MM_RET_H)
#define MM_RET_H



enum	MmRet
{
    mmRetOk			= 0,

    mmRetControlCantClone,
    mmRetControlEventNotExec,
    mmRetControlExecNoSeg,
    mmRetControlFileShort,
    mmRetControlWaitMismatch,
    mmRetControlWontExec,
    mmRetControlWontKill,

    mmRetExeEofPremature,
    mmRetExeMagicBad,

    mmRetFileCountNegative,
    mmRetFileEofPremature,
    mmRetFileIsOpen,
    mmRetFileIsOutput,
    mmRetFileNameNotCcs,
    mmRetFileNotOpen,
    mmRetFileNotOutput,
    mmRetFileWontClose,
    mmRetFileWontFstat,
    mmRetFileWontOpen,
    mmRetFileWontRead,
    mmRetFileWontUnlink,
    mmRetFileWontWrite,

    mmRetFlatAddrRange,
    mmRetFlatBoolBad,
    mmRetFlatCountNegative,
    mmRetFlatIndexNegative,
    mmRetFlatEnumBad,
    mmRetFlatEnd,
    mmRetFlatTagBad,

    mmRetReplayEventNotExec,
    mmRetReplayExecNoSeg,
    mmRetReplayFileShort,
    mmRetReplayWaitMismatch,
    mmRetReplayWontFwrite,

    mmRetSciAddrBad,
    mmRetSciSegBad,
    mmRetSciSegMismatch,
    mmRetSciSegOverlap,

    mmRetScoSegBad,
    mmRetScoStoreCant,

    mmRetSegWontFetch,
    mmRetSegWontStore,

    mmRetTraceWaitMismatch
};



#define MmRetCheck(expr)	do {				\
				    const MmRet mmRet = (expr);	\
				    if ( mmRet != mmRetOk )	\
				    	return mmRet;		\
				} while (0)

#define MmRetThrow(expr)	return MmRetRaise( expr )

MmRet	MmRetRaise		( MmRet );



#endif
