// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSco.h
//   An event, type 'system call outcoming'.
//   This is a leaf class.
//
// File Created:	13 Apr 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#if !defined(EV_SCO_H)
#define EV_SCO_H

#include <EvBase.h>
#include <MmMap.h>
#include <MmType.h>
#include <PrScr.h>
#include <WhList.h>
#include <WhString.h>



class	EvSco			: public EvBase
{
    // Constructor, destructor, and copier.
    public:
				EvSco		(		   );
				~EvSco		(		   );
	virtual EvBase *	copy		(		   ) const;

    // RTTI.
    public:
	const EvSco *		ptrEvSco	(		   ) const;

    // Flat interface (combiner).
    private:
	MmRet			fromFlatEv	( MmFlat &	   );
	void			toFlatEv	( MmFlat &	   ) const;

    // String interface (combiner).
    private:
	void			fmtStrEv	( WhString &	   ) const;

    // Process interface.
    public:
	MmRet			fetch		( const PrProc &,
						  const MmMap &,
						  const EvSci *	   );
	MmRet			storeAfterWait	( PrProc &,
						  const EvSci *	   ) const;
	MmRet			storeBeforeCont	( PrProc &,
						  const EvSci *	   ) const;

    // Return value interface.
    public:
	bool			isScrError	(		   ) const;
	MmWord			getScrWord	( int iwRet	   ) const;

    // Instance data.
    private:
	bool			fBound_;	// Bound to value.
	PrScr			scr_;		// Sys call return.
	WhList <MmWord>		lwSmash_;	// Regs smashed on replay.
};



// Inline methods.

inline bool EvSco::isScrError( ) const
{
    return scr_.isError( );
}

inline MmWord EvSco::getScrWord( int iwRet ) const
{
    return scr_.getWord( iwRet );
}



#endif
