// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSco.cc
//   An event, type 'system call outcoming'.
//   This is a leaf class.
//
// File Created:	13 Apr 1995		Michael Chastain
// Last Edited:		12 Sep 1995		Michael Chastain

#include <EvSci.h>
#include <EvSco.h>
#include <MmArea.h>
#include <MmMap.h>
#include <MmSeg.h>
#include <MmType.h>
#include <ScLine.h>
#include <WhAbort.h>



// Constructor.
EvSco::EvSco( )
    : fBound_		( false	)
    , scr_		(	)
    , lwSmash_		(	)
{
    ;
}



// Destructor.
EvSco::~EvSco( )
{
    ;
}



// Copier.
EvBase * EvSco::copy( ) const
{
    return new EvSco( *this );
}



// RTTI.
const EvSco * EvSco::ptrEvSco( ) const
{
    return this;
}



// Flat input (combiner).
MmRet EvSco::fromFlatEv( MmFlat & flatFrom )
{
    MmRetCheck( flatFrom.getBool	( fBound_	) );
    MmRetCheck( scr_.fromFlat		( flatFrom	) );
    MmRetCheck( flatFrom.getListWord	( lwSmash_	) );
    return mmRetOk;
}



// Flat output (combiner).
void EvSco::toFlatEv( MmFlat & flatTo ) const
{
    flatTo.putBool	( fBound_	);
    scr_.toFlat		( flatTo	);
    flatTo.putListWord	( lwSmash_	);
}



// Format to string (combiner).
void EvSco::fmtStrEv( WhString & strRet ) const
{
    if ( !fBound_ )
	WhAbort( "EvSco::fmtStr: not bound." );

    scr_.fmtScr ( strRet );
    fmtAllSeg   ( strRet );
    fmtAllFlat  ( strRet );
}



// Fetch from process.
MmRet EvSco::fetch( const PrProc & procFetch, const MmMap & mapFetch,
    const EvSci * pevSci )
{
    // Clear.
    fBound_	= false;
    scr_.clear	( );
    clearSeg	( );
    clearFlat	( );

    // Check pointer.
    if ( pevSci == 0 )
	WhAbort( "EvSco::fetch: zero pointer." );

    // Fetch fetch fetch.
    ScLine scLineIn;
    pevSci->getScLine( scLineIn );
    MmRetCheck( scLineIn.fetchScr( procFetch, scr_ ) );
    MmRetCheck( scLineIn.fetchRegSmash( procFetch, lwSmash_ ) );
    MmRetCheck( scLineIn.fetchSeg( false, procFetch, mapFetch, *pevSci,
	*this, *this ) );

    // That's all, folks.
    fBound_ = true;
    return mmRetOk;
}



// Store to process.
MmRet EvSco::storeAfterWait( PrProc & procStore, const EvSci * pevSci ) const
{
    // Check pointer.
    if ( pevSci == 0 )
	WhAbort( "EvSco::storeAfterWait: zero pointer." );

    // Check value.
    if ( !fBound_ )
	WhAbort( "EvSco::storeAfterWait: not bound." );

    // Check for unknown events.
    if ( isUnknown( ) )
	return MmRetRaise( mmRetScoStoreCant );

    // Store sys call return value.
    scr_.storeProc( procStore );

    // Store smashed registers.
    for ( int iSmash = 0; iSmash < lwSmash_.count( ); ++iSmash )
    {
	if ( !procStore.storeReg( iSmash, lwSmash_[iSmash] ) )
	    WhAbort( "EvSco::storeAfterWait: failed store." );
    }

    // Store segments.
    for ( int isegOut = 0; isegOut < getSeg( ).count( ); ++isegOut )
    {
	const MmSeg & segOut = getSeg( )[isegOut];
	if ( segOut.isBound( ) )
	    MmRetCheck( segOut.storeProc( procStore ) );
    }

    // Unlink flats.
    for ( int iFlat = 0 ; iFlat < pevSci->getFlat( ).count( ); ++iFlat )
    {
	const MmFlat & flatStore = pevSci->getFlat( )[iFlat];
	WhString strSmash( flatStore.getFileName( ) );
	strSmash.replaceChr( '/', '%' );
	WhFile fileStore;
	MmRetCheck( fileStore.unlinkName( strSmash ) );
    }

    // Success.
    return mmRetOk;
}



// Store to process.
MmRet EvSco::storeBeforeCont( PrProc &, const EvSci * ) const
{
    return mmRetOk;
}
