// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSci.cc
//   An event, type 'system call ingoing'.
//   This is a leaf class.
//
// File Created:	11 Apr 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#include <EvSci.h>
#include <EvSco.h>
#include <MmArea.h>
#include <MmMap.h>
#include <MmSeg.h>
#include <MmType.h>
#include <PrScr.h>
#include <RiLine.h>
#include <ScLine.h>
#include <WhAbort.h>
#include <WhList.h>
#include <WhString.h>



// Constructor.
EvSci::EvSci( )
    : fEntry_		( false	)
    , fArg_		( false )
    , fSeg_		( false )
    , wSysEntry_	( 0	)
    , wSubEntry_	( 0	)
    , lwArg_		(	)
{
    ;
}



// Destructor.
EvSci::~EvSci( )
{
    ;
}



// Copier.
EvBase * EvSci::copy( ) const
{
    return new EvSci( *this );
}



// RTTI.
const EvSci * EvSci::ptrEvSci ( ) const
{
    return this;
}



// Flat input (combiner).
MmRet EvSci::fromFlatEv( MmFlat & flatFrom )
{
    MmRetCheck( flatFrom.getBool	( fEntry_	) );
    MmRetCheck( flatFrom.getBool	( fArg_		) );
    MmRetCheck( flatFrom.getBool	( fSeg_		) );
    MmRetCheck( flatFrom.getWord	( wSysEntry_	) );
    MmRetCheck( flatFrom.getWord	( wSubEntry_	) );
    MmRetCheck( flatFrom.getListWord	( lwArg_	) );
    return mmRetOk;
}



// Flat output (combiner).
void EvSci::toFlatEv( MmFlat & flatTo ) const
{
    flatTo.putBool	( fEntry_	);
    flatTo.putBool	( fArg_		);
    flatTo.putBool	( fSeg_		);
    flatTo.putWord	( wSysEntry_	);
    flatTo.putWord	( wSubEntry_	);
    flatTo.putListWord	( lwArg_	);
}



// Format to string (combiner).
void EvSci::fmtStrEv( WhString & strRet ) const
{
    ScLine scLine;
    getScLine( scLine );
    scLine.fmtStrEvSci( strRet, *this );
}



// Fetch from process.
MmRet EvSci::fetch( const PrProc & procFetch, const MmMap & mapFetch,
    const EvSci * )
{
    // Clear.
    fEntry_   = false;
    fArg_     = false;
    fSeg_     = false;
    clearSeg  ( );
    clearFlat ( );

    // Fetch sys entry # and sub entry #.
    if ( !procFetch.fetchSysEntry( wSysEntry_, wSubEntry_ ) )
	WhAbort( "EvSci::fetch: failed fetch." );
    fEntry_ = true;

    // Get sys call line.
    ScLine scLine;
    getScLine( scLine );

    // Fetch arguments.
    MmRetCheck( scLine.fetchArg( procFetch, fArg_, lwArg_ ) );

    // Fetch segments.
    EvSco evScoBlank;
    MmRetCheck( scLine.fetchSeg( true, procFetch, mapFetch, *this,
	evScoBlank, *this ) );
    fSeg_ = true;

    // That's all, folks.
    return mmRetOk;
}



// Store to process.
MmRet EvSci::storeAfterWait( PrProc &, const EvSci * ) const
{
    return mmRetOk;
}



// Store to process.
MmRet EvSci::storeBeforeCont( PrProc & procStore, const EvSci * ) const
{
    // Store flats.
    //   Flats are stored in current directory and unlinked later.
    for ( int iFlat = 0; iFlat < getFlat( ).count( ); ++iFlat )
    {
	const MmFlat & flatStore = getFlat( )[iFlat];
	WhString strSmash( flatStore.getFileName( ) );
	strSmash.replaceChr( '/', '%' );

	WhFile fileStore;
	MmRetCheck( fileStore.openName( strSmash, WhFile::tyOpenWriteExe ) );
	MmRetCheck( flatStore.toFile( fileStore ) );
	MmRetCheck( fileStore.closeFile( ) );
    }

    // Smash registers to annul system call.
    ScLine scLine;
    getScLine( scLine );
    MmRetCheck( scLine.smash( procStore, *this ) );

    // That's all, folks.
    return mmRetOk;
}



// Get an argument.
MmWord EvSci::getArg( int iArg ) const
{
    if ( !fArg_ )
	WhAbort( "EvSci::getArg: not bound." );
    return lwArg_[iArg];
}



// Get sys call line.
void EvSci::getScLine( ScLine & scLineRet ) const
{
    if ( !fEntry_ )
	WhAbort( "EvSci::getScLine: not bound." );

    scLineRet.initFromSce( wSysEntry_, wSubEntry_ );
}



// Get sys entry.
MmWord EvSci::getSysEntry( ) const
{
    if ( !fEntry_ )
	WhAbort( "EvSci::getSysEntry: not bound." );
    return wSysEntry_;
}
