// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvHistory.h
//   A list of events.
//   This is a concrete class.
//
// File Created:	28 Jun 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#if !defined(EV_HISTORY_H)
#define EV_HISTORY_H

#include <EvEvent.h>
#include <MmFlat.h>
#include <MmMap.h>
#include <MmRet.h>
#include <PrProc.h>
#include <WhList.h>



class	EvHistory
{
    // Constructor.
    public:
    				EvHistory	(		   );

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Process interface.
    public:
	MmRet			fetch		( PrProc &, MmMap &,
						  bool	           );
	MmRet			storeAfterWait	( PrProc &	   ) const;
	MmRet			storeBeforeCont	( PrProc &	   ) const;

    // Accessors.
    public:
	int			count		(		   ) const;
	const EvEvent &		getEvCur	(		   ) const;
	const EvEvent &		getEvIndex	( int		   ) const;
	bool			isAtEnd		(		   ) const;

    // Mutators.
    public:
	void			advEvCur	(		   );

    // Instance data.
    private:
	WhList <EvEvent>	lev_;		// List of events.
	int			iev_;		// Current event.
	EvEvent			evSciLast_;	// Last evSci seen.
};



// Inline methods.

inline int EvHistory::count( ) const
{
    return lev_.count( );
}

inline const EvEvent & EvHistory::getEvCur( ) const
{
    return lev_[iev_];
}

inline const EvEvent & EvHistory::getEvIndex( int iev ) const
{
    return lev_[iev];
}

inline bool EvHistory::isAtEnd( ) const
{
    return !lev_.isInRange( iev_ );
}



#endif
