// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvHistory.cc
//   A list of events.
//   This is a concrete class.
//
// File Created:	28 Jun 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#include <EvBlank.h>
#include <EvHistory.h>
#include <MmTag.h>
#include <WhAbort.h>



// Constructor.
EvHistory::EvHistory( )
    : lev_		(	)
    , iev_		( 0	)
    , evSciLast_	(	)
{
    evSciLast_.initBlank( );
}



// Flat input.
MmRet EvHistory::fromFlat( MmFlat & flatFrom )
{
    // Check tag.
    int iTag;
    MmRetCheck( flatFrom.getInt( iTag ) );
    if ( iTag != int( mmTagHistory ) )
	return MmRetRaise( mmRetFlatTagBad );
    
    // Get count of events.
    int nev;
    MmRetCheck( flatFrom.getInt( nev ) );
    if ( nev < 0 )
	return MmRetRaise( mmRetFlatCountNegative );

    // Get events.
    lev_.clear( nev );
    for ( int iev = 0; iev < nev; ++iev )
    {
	EvEvent ev;
	MmRetCheck( ev.fromFlat( flatFrom ) );
	lev_.append( ev );
    }

    // Get more fields.
    MmRetCheck( flatFrom.getInt     ( iev_        ) );
    MmRetCheck( evSciLast_.fromFlat ( flatFrom    ) );

    // That's all, folks.
    return mmRetOk;
}



// Flat output.
void EvHistory::toFlat( MmFlat & flatTo ) const
{
    flatTo.putInt	( int( mmTagHistory )		);
    flatTo.putInt	( lev_.count( )			);
    for ( int iev = 0; iev < lev_.count( ); ++iev )
	lev_[iev].toFlat( flatTo );
    flatTo.putInt	( iev_				);
    evSciLast_.toFlat	( flatTo		  	);
}



// Fetch from process.
MmRet EvHistory::fetch( PrProc & procFetch, MmMap & mapFetch, bool fTime )
{
    // Fetch an event.
    EvEvent evFetch;
    evFetch.initFromProc( procFetch );
    if ( fTime )
	evFetch.setStamp( procFetch.getTimeWait( ) );
    MmRetCheck( evFetch.fetch( procFetch, mapFetch, evSciLast_.ptrEvSci( ) ) );

    // Update map and process state.
    procFetch.followDir( evSciLast_.ptrEvSci( ), evFetch.ptrEvSco( ) );
    evFetch.mergeMap( mapFetch );

    // Record last evSci seen.
    if ( evFetch.ptrEvSci( ) != 0 )
	evSciLast_ = evFetch;

    // That's all, folks.
    lev_.append( evFetch );
    return mmRetOk;
}



// Store to process.
MmRet EvHistory::storeAfterWait( PrProc & procStore ) const
{
    return getEvCur( ).storeAfterWait( procStore, evSciLast_.ptrEvSci( ) );
}



// Store to process.
MmRet EvHistory::storeBeforeCont( PrProc & procStore ) const
{
    return getEvCur( ).storeBeforeCont( procStore, evSciLast_.ptrEvSci( ) );
}



// Advance current event.
void EvHistory::advEvCur( )
{
    if ( !isAtEnd( ) )
    {
        if ( lev_[iev_].ptrEvSci( ) != 0 )
	    evSciLast_ = lev_[iev_];
	++iev_;
    }
}
