// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvEvent.h
//   An event.
//   This is an envelope class.
//
// File Created:	20 Sep 1994		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#if !defined(EV_EVENT_H)
#define EV_EVENT_H

#include <EvBase.h>
#include <MmMap.h>
#include <MmTag.h>



class	EvEvent
{
    // Enumeration of types.
    public:
	enum	TyEvEvent
	{
		tyEvBlank	= int(mmTagEvent) + 1,
		tyEvExec,
		tyEvFirst,
		tyEvSignal,
		tyEvSci,
		tyEvSco
	};

    // Constructors, copiers, and destructors.
    public:
				EvEvent		(		   );
				EvEvent		( const EvEvent &  );
	const EvEvent &		operator =	( const EvEvent &  );
				~EvEvent	(		   );

    // RTTI.
    public:
	const EvSci   *		ptrEvSci	(		   ) const;
	const EvSco   *		ptrEvSco	(		   ) const;

    // Initialization.
    public:
    	void			initBlank	(		   );
    	void			initFromProc	( const PrProc &   );

    // Unknown attribute.
    public:
	bool			isUnknown	(		   ) const;
	void			setUnknown	( bool		   );

    // Time stamp.
    public:
	bool			hasStamp	(		   ) const;
	const PrTime &		getStamp	(		   ) const;
	void			setStamp	( const PrTime &   );

    // Flat methods.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // String conversion.
    public:
	void			fmtStr		( WhString &	   ) const;

    // Process interface.
    public:
	MmRet			fetch		( const PrProc &,
						  const MmMap &,
						  const EvSci *	   );
	MmRet			storeAfterWait	( PrProc &,
						  const EvSci *	   ) const;
	MmRet			storeBeforeCont	( PrProc &,
						  const EvSci *	   ) const;

    // Segment interface.
    public:
	const WhList <MmSeg> &	getSeg		(		   ) const;

    // Map interface.
    public:
	void			mergeMap	( MmMap &	   ) const;

    // Helper methods.
    private:
	void			copyUnique	(		   );

    // Instance data.
    private:
	EvBase *		pev_;		// Pointer to letter.
	TyEvEvent		tyEvEvent_;	// Event type.
};



// Inline methods.

inline const EvSci * EvEvent::ptrEvSci( ) const
{
    return pev_->ptrEvSci( );
}

inline const EvSco * EvEvent::ptrEvSco( ) const
{
    return pev_->ptrEvSco( );
}

inline bool EvEvent::isUnknown( ) const
{
    return pev_->isUnknown( );
}

inline void EvEvent::setUnknown( bool fUnknown )
{
    if ( pev_->countRef( ) > 1 )
	copyUnique( );
    pev_->setUnknown( fUnknown );
}

inline bool EvEvent::hasStamp( ) const
{
    return pev_->hasStamp( );
}

inline const PrTime & EvEvent::getStamp( ) const
{
    return pev_->getStamp( );
}

inline void EvEvent::setStamp( const PrTime & timeStamp )
{
    if ( pev_->countRef( ) > 1 )
	copyUnique( );
    pev_->setStamp( timeStamp );
}

inline void EvEvent::fmtStr( WhString & strRet ) const
{
    pev_->fmtStr( strRet );
}

inline MmRet EvEvent::fetch( const PrProc & procFetch, const MmMap & mapFetch,
    const EvSci * pevSci )
{
    if ( pev_->countRef( ) > 1 )
	copyUnique( );
    return pev_->fetch( procFetch, mapFetch, pevSci );
}

inline MmRet EvEvent::storeAfterWait( PrProc & procStore,
    const EvSci * pevSci ) const
{
    return pev_->storeAfterWait( procStore, pevSci );
}

inline MmRet EvEvent::storeBeforeCont( PrProc & procStore,
    const EvSci * pevSci ) const
{
    return pev_->storeBeforeCont( procStore, pevSci );
}

inline const WhList <MmSeg> & EvEvent::getSeg( ) const
{
    return pev_->getSeg( );
}

inline void EvEvent::mergeMap( MmMap & mapMerge ) const
{
    pev_->mergeMap( mapMerge );
}



#endif
