// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvEvent.cc
//   An event.
//   This is an envelope class.
//
// File Created:	20 Sep 1994		Michael Chastain
// Last Edited:		30 Jun 1995		Michael Chastain

#include <EvBlank.h>
#include <EvExec.h>
#include <EvFirst.h>
#include <EvSci.h>
#include <EvSco.h>
#include <EvEvent.h>
#include <WhAbort.h>



// Constructor.
EvEvent::EvEvent( )
    : pev_		( 0		) 	// (&evBlank)
    , tyEvEvent_	( tyEvBlank	)
{
    static EvBlank evBlank;
    pev_ = &evBlank;
    pev_->addRef( );
}



// Copy constructor.
EvEvent::EvEvent( const EvEvent & evOld )
    : pev_		( evOld.pev_		)
    , tyEvEvent_	( evOld.tyEvEvent_	)
{
    pev_->addRef( );
}



// Assignment operator.
const EvEvent & EvEvent::operator = ( const EvEvent & evOld )
{
    evOld.pev_->addRef( );
    pev_->removeRef( );
    if ( pev_->countRef( ) <= 0 )
	delete pev_;
    pev_       = evOld.pev_;
    tyEvEvent_ = evOld.tyEvEvent_;
    return *this;
}



// Destructor.
EvEvent::~EvEvent( )
{
    pev_->removeRef( );
    if ( pev_->countRef( ) <= 0 )
	delete pev_;
    pev_ = 0;
}



// Initializer.
void EvEvent::initBlank( )
{
    static EvBlank evBlank;
    pev_->removeRef( );
    if ( pev_->countRef( ) <= 0 )
	delete pev_;
    pev_ = &evBlank;
    pev_->addRef( );
}



// Initializer.
void EvEvent::initFromProc( const PrProc & procInit )
{
    // Define archetypes.
    static EvBlank evBlank;
    static EvFirst evFirst;
    static EvSci   evSci;
    static EvExec  evExec;
    static EvSco   evSco;

    // Remove reference to old value.
    pev_->removeRef( );
    if ( pev_->countRef( ) <= 0 )
	delete pev_;

    // Initialize reference to archetype.
    switch ( procInit.getSysState( ) )
    {
    default:                 WhAbort( "EvEvent::initFromProc: bad enum." );
    case PrProc::stSysBlank: pev_ = &evBlank; tyEvEvent_ = tyEvBlank; break;
    case PrProc::stSysFirst: pev_ = &evFirst; tyEvEvent_ = tyEvFirst; break;
    case PrProc::stSysSci:   pev_ = &evSci;   tyEvEvent_ = tyEvSci;   break;
    case PrProc::stSysExec:  pev_ = &evExec;  tyEvEvent_ = tyEvExec;  break;
    case PrProc::stSysSco:   pev_ = &evSco;   tyEvEvent_ = tyEvSco;   break;
    }
    pev_->addRef( );
}



// Flat input.
MmRet EvEvent::fromFlat( MmFlat & flatFrom )
{
    // Grab the type.
    int ityEvEvent;
    MmRetCheck( flatFrom.getInt( ityEvEvent ) );

    // Construct new letter.
    EvBase * pevNew = 0;
    switch ( ityEvEvent )
    {
    default:		return MmRetRaise( mmRetFlatEnumBad );
    case tyEvBlank:	pevNew = new EvBlank;	break;
    case tyEvExec:	pevNew = new EvExec;	break;
    case tyEvFirst:	pevNew = new EvFirst;	break;
    // case tyEvSignal:	pevNew = new EvSignal;	break;
    case tyEvSci:	pevNew = new EvSci;	break;
    case tyEvSco:	pevNew = new EvSco;	break;
    }
    if ( pevNew == 0 )
	WhAbort( "EvEvent::fromFlat: out of memory." );

    // Swap in new value.
    pev_->removeRef( );
    if ( pev_->countRef( ) <= 0 )
	delete pev_;
    pev_       = pevNew;
    pevNew     = 0;
    tyEvEvent_ = TyEvEvent( ityEvEvent );

    // Dispatch input methods.
    MmRetCheck( pev_->fromFlat( flatFrom ) );
    return mmRetOk;
}



// Flat output.
void EvEvent::toFlat( MmFlat & flatTo ) const
{
    flatTo.putInt( int( tyEvEvent_ ) );
    pev_->toFlat( flatTo );
}



// Make the letter be unique.
void EvEvent::copyUnique( )
{
    if ( pev_->countRef( ) > 1 )
    {
	pev_->removeRef( );
	pev_ = pev_->copy( );
	if ( pev_ == 0 )
	    WhAbort( "EvEvent::copyUnique: out of memory." );
    }
}
