// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ControlArg.h
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Jun 1995		Michael Chastain
// Last Edited:		05 Jun 1995		Michael Chastain

#if !defined(CONTROL_ARG_H)
#define CONTROL_ARG_H

#include <WhString.h>



class	ControlArg
{
    // Constructor.
    public:
				ControlArg	( int,
						  const char * const *,
						  const char * const *
						  		   );
    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	const WhString &	getFileIn	(		   ) const;
	const char * const *	getEnvp		(		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	WhString		strFileIn_;	// 'file'.
	const char * const *	argv_;		// Original 'argv'.
	const char * const *	envp_;		// Original 'envp'.
};



// Inline methods.

inline bool ControlArg::isError( ) const
{
    return fError_;
}

inline bool ControlArg::hasHelp( ) const
{
    return fHelp_;
}

inline const WhString & ControlArg::getFileIn( ) const
{
    return strFileIn_;
}

inline const char * const * ControlArg::getEnvp( ) const
{
    return envp_;
}



#endif
