/*
xpat.c Version 1.7.0. Random Pattern in X Windows.
Copyright (C) 2001-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* Commands when running xpat: */
/* r = reset */
/* q = quit  */

/* Define UPPERLEFT if you want to fix the */
/* window in the upper left corner of your */
/* desktop. */
/* The default is to let X Windows position */
/* the program on the desktop. */
/*               #define UPPERLEFT 1                */
#undef UPPERLEFT

/* to define the escape key */
#define XK_MISCELLANY 1

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <assert.h>
#include "rnd.h"

/* If the Debian font 8x16 doesn't exist on your */
/* system, then try a similar font. */
/******************** #define FONT "linux8x16"  ******************/
#define FONT "8x16"
#define NIL (0)
#define SCRW 624
#define SCRH 440
/* COLORS is the power of 2 */
/* 2^4 = 16 */
#define COLORS 4

int whiteColor,blackColor;
int runflg;
unsigned long colortbl[32];
Display *dpy;
Window w;
GC gc;
Font fontid;
Screen *dfltscr;
Colormap cmap;
XColor scrdef,exctdef;

/* X Windows code is based on: */
/* http://tronche.lri.fr:8000/gui/x/xlib-tutorial/2nd-program-anatomy.html */

void clrscr()
   {
   XSetForeground(dpy, gc, whiteColor);
   XFillRectangle(dpy,w,gc,0,0,SCRW,SCRH);
   } /* clrscr */

void getkey()
   {
   int msk;
   int symbol;
   int XCheckMaskEvent();
   XEvent e;
   XKeyEvent *k;

   msk = KeyPressMask|ExposureMask;

   XSelectInput(dpy, w, msk);

   while (XCheckMaskEvent(dpy, msk, &e))
      {
      if (e.type == KeyPress)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Escape
            || symbol == 'q'
            || symbol == 'Q')
            {
            runflg = 0;
            } /* if quit */
         else if (symbol == 'r')
            {
            clrscr();
            } /* if reset */
         } /* if keypress event */
      else if (e.type == Expose)
         {
         clrscr();
         } /* if expose event */
      } /* if event received */
   } /* getkey */

unsigned long getcolor(txt)
char *txt;
   {
   int rslt;
   rslt = XAllocNamedColor(dpy,cmap,txt,
      &scrdef,&exctdef);
   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed: %s\n", txt);
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   return(scrdef.pixel);
   } /* getcolor */

void initx()
   {
   char title[64];
   unsigned long getcolor();

   dpy = XOpenDisplay(NIL);

   if (dpy == NULL)
      {
      fprintf(stderr,"X Windows failure\n");
      exit(1);
      } /* if X Windows is not active */

   assert(dpy);

   whiteColor = WhitePixel(dpy, DefaultScreen(dpy));
   blackColor = BlackPixel(dpy, DefaultScreen(dpy));

   w = XCreateSimpleWindow(dpy,
      DefaultRootWindow(dpy),
      0, 0, 
      SCRW, SCRH,
      0, whiteColor,
      whiteColor);

   XSelectInput(dpy, w, StructureNotifyMask);

   XMapWindow(dpy, w);

   gc = XCreateGC(dpy, w, 0, NIL);

   fontid = (Font) XLoadFont(dpy,FONT);

   XSetFont(dpy,gc,fontid);

   XSetForeground(dpy, gc, blackColor);

   dfltscr = XDefaultScreenOfDisplay(dpy);
   if (dfltscr == NULL)
      {
      fprintf(stderr,"XDefaultScreenOfDisplay failed\n");
      perror("XDefaultScreenOfDisplay failed");
      exit(1);
      } /* if error */

   cmap = XDefaultColormapOfScreen(dfltscr);

   /* colors are chosen from */
   /* /usr/lib/X11/rgb.txt */

   colortbl[0]  = getcolor("red");
   colortbl[1]  = getcolor("green");
   colortbl[2]  = getcolor("blue");
   colortbl[3]  = getcolor("yellow");
   colortbl[5]  = getcolor("navy");
   colortbl[6]  = getcolor("cyan");
   colortbl[7]  = getcolor("magenta");
   colortbl[4]  = getcolor("orange");
   colortbl[8]  = getcolor("gray50");
   colortbl[9]  = getcolor("SpringGreen");
   colortbl[10] = getcolor("chartreuse");
   colortbl[11] = getcolor("purple");
   colortbl[12] = getcolor("DarkRed");
   colortbl[13] = getcolor("pink");
   colortbl[14] = getcolor("black");
   colortbl[15] = getcolor("brown");

   XSetWindowBorderWidth(dpy, w, 40);

   sprintf(title,"xpat");
   XStoreName(dpy,w,title);
   XSetIconName(dpy,w,title);

#ifdef UPPERLEFT
   XMoveWindow(dpy,w,0,0);
#endif

   while(1)
      {
      XEvent e;
      XNextEvent(dpy, &e);
      if (e.type == MapNotify) break;
      } /* wait for window initialization */

   } /* initx */

void runpat()
   {
   int col,row,clr;
   runflg = 1;
   while (runflg)
      {
      col = rndnum(SCRW,sd);
      row = rndnum(SCRH,sd);
      clr = rndpwr(4,sd);
      XSetForeground(dpy, gc, colortbl[clr]);
      XDrawPoint(dpy,w,gc,col,row);
      getkey();
      }
   } /* runpat */

int main()
   {
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"xpat: out or memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */
   initx();
   runpat();
   return(0);
   } /* main */
