/*
sercoruv.c Version 1.7.0 - Serial Correlation Test
of independent series U and V.
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n", pgm);
   fprintf(stderr,"Where size is 10 - 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,size;
   double tmpu,tmpv;
   double sumu,sumuv,sumusq;
   double sumv,sumvsq;
   double top,botu,botv,correl;
   double mu,sigma;
   double from,to;
   unsigned char *seedu;
   unsigned char *seedv;
   unsigned char *p,*q,*r;
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 10 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   sd = (unsigned char *) rndinit();  /* initialize seed */
   if (sd == NULL)
      {
      fprintf(stderr,"sercoruv: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */
   seedu = (unsigned char *) malloc(32);  /* allocate seedu */
   if (seedu == NULL)
      {
      fprintf(stderr,"sercoruv: out of memory "
	 "allocating seedu\n");
      exit(1);
      } /* out of mem */
   seedv = (unsigned char *) malloc(32);  /* allocate seedv */
   if (seedv == NULL)
      {
      fprintf(stderr,"sercoruv: out of memory "
	 "allocating seedv\n");
      exit(1);
      } /* out of mem */
   p = (unsigned char *) sd;
   q = (unsigned char *) sd + 16;
   r = (unsigned char *) seedu;
   while (p < q) *r++ = *p++;
   *r = '\0';
   i=4096;
   while (i--) rnd(sd);  /* churn the seed */
   p = (unsigned char *) sd;
   q = (unsigned char *) sd + 16;
   r = (unsigned char *) seedv;
   while (p < q) *r++ = *p++;
   *r = '\0';
   i=4096;
   while (i--) rnd(sd);  /* churn the seed some more */
   i=0;
   while (i < 16)  /* create unique seedv */
      {
      seedv[i] ^= sd[i];  /* combine two seeds into one */
      i++;
      } /* create unique seedv */
   sumuv = sumu = sumusq =
      sumv = sumvsq = 0.0;
   i = 0;
   while (i++ < size)
      {
      /* separate seeds make U and V independent */
      tmpu = rndfrac(sd);
      tmpv = rndfrac(sd);
      sumuv += tmpu * tmpv;
      sumu += tmpu;
      sumv += tmpv;
      sumusq += tmpu * tmpu;
      sumvsq += tmpv * tmpv;
      } /* for each i in size */
   top = (size * sumuv) - (sumu * sumv);
   botu = (size * sumusq) - (sumu * sumu);
   botv = (size * sumvsq) - (sumv * sumv);
   correl = top / sqrt(botu * botv);
   printf("%f\n", correl);
   mu = (double) -1.0 / (size - 1.0);
   sigma = (double) -mu
      * sqrt((size * (size - 3.0)) / (size + 1.0));
   from = mu - (2.0 * sigma);
   to = mu + (2.0 * sigma);
   printf("Range at 95 percent: %f  to  %f\n",
      from, to);
   free(seedu);
   free(seedv);
   return(0);
   } /* main */
