/*
runsup.c Version 1.7.0 - Runs Up Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage %s size\n", pgm);
   fprintf(stderr,"Where size is 4000 - 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,len,totlen;
   int *numlst;
   int *cardlst;
   int *cardlstptr;
   int *cardlstend;
   int uplst[16];
   int *p,*q;
   double dbl,statv;
   double a[7][7] = {
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4529.4, 9044.9, 13568, 18091, 22615, 27892},
      {0.0, 9044.9, 18097, 27139, 36187, 45234, 55789},
      {0.0, 13568, 27139, 40721, 54281, 67852, 83685},
      {0.0, 18091, 36187, 54281, 72414, 90470, 111580},
      {0.0, 22615, 45234, 67852, 90470, 113262, 139476},
      {0.0, 27892, 55789, 83685, 111580, 139476, 172860}
      };
   double b[16];
   if (argc != 2) putstx(*argv);
   len = atoi(*(argv+1));
   if (len < 4000 || len > 1000000) putstx(*argv);
   numlst = (int *) malloc(len*sizeof(int)+16);
   if (numlst == NULL)
      {
      fprintf(stderr,"runsup: out of memory "
	 "allocating numlst\n");
      exit(1);
      } /* out of mem */
   cardlst = (int *) malloc(len*sizeof(int)+16);
   if (numlst == NULL)
      {
      fprintf(stderr,"runsup: out of memory "
	 "allocating cardlst\n");
      exit(1);
      } /* out of mem */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"runsup: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */
   b[0] = 0.0;
   b[1] = 1.0 / 6.0;
   b[2] = 5.0 / 24.0;
   b[3] = 11.0 / 120.0;
   b[4] = 19.0 / 720.0;
   b[5] = 29.0 / 5040.0;
   b[6] = 1.0 / 840.0;
   p = cardlst;
   q = cardlst + len;
   cardlstend = q - 1;
   i = 0;
   while (p < q)
      {
      *p++ = i++;
      } /* fill numlst */
   p = uplst;
   q = uplst+16;
   while (p < q) *p++ = 0;
   p = numlst;
   q = numlst + len;
   totlen = len;
   while (p < q)
      {
      cardlstptr = cardlst + (int) rndnum(totlen,sd); 
      *p++ = *cardlstptr;
      *cardlstptr = *cardlstend;
      *cardlstend-- = 0;
      totlen--;
      } /* fill numlst */
   p = numlst;
   q = numlst + len;
   i = 0;
   while (p < q)
      {
      i++;
      if (*p > *(p+1))
         {
         if (i > 5) uplst[6]++;
         else uplst[i]++;
         i = 0;
         } /* record sub-len */
      p++;
      } /* for each number */
   statv = 0.0;
   for (i=1;i<=6;i++)
      {
      for (j=1;j<=6;j++)
         {
         dbl = (double) (uplst[i] - (len * b[i]))
            * (uplst[j] - (len * b[j]))
            * a[i][j];
         statv += dbl;
         } /* by column */
      } /* by row */
   statv /= len;
   printf("%f\n", statv);
   printf("Range at 95 percent: %15.5f   to %15.5f\n",
      0.8720, 16.81);
   return(0);
   } /* main */
