/*
roulette.c Version 1.7.0 - Dice Rolling Test
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* John Scarne */
/* Scarne's New Complete Guide to Gambling */
/* Fully revised, expanded, updated edition */
/* New York: Simon & Schuster, 1961, 1974, 1986 */
/* A Fireside book, 871 p. */
/* ISBN: 0-671-21734-8 hardback */
/* ISBN: 0-671-63063-6 paperback */
/* Chapter 14, Roulette */
/* Section: Possible Roulette Bets, Odds and Percentages */

/* Sample test: */

/* roulette 10000 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n",
      pgm);
   fprintf(stderr,"Where size is 30 to 1000000\n");
   exit(1);
   } /* putstx */

void tally(int size, char *spin)
   {
   int i;
   int totspin;
   int *sqptr;
   int *sqend;
   int sq[48];
   char *spinptr;
   char *spinend;
   double totprob;
   double dblsz;
   double rootsz;
   double portion;
   double totportion;
   double dbli;
   double dblobs;
   double estx;
   double estxsq;
   double sumx;
   double sumxsq;
   double popmu;
   double popvar;
   double popstdev;
   double mean;
   double variance;
   double stdev;
   double std_err;
   double zval;
   double zscore;
   double expect;
   double diff;
   double sumchi;
   double lorange;
   double hirange;
   double *probptr;
   double *probend;
   double prob[48];
   void chirange(int degf, double *lorange,
      double *hirange);
   probptr = (double *) prob;
   *probptr++ = 0.0;
   probend = (double *) probptr + 38;
   while (probptr < probend)
      *probptr++ = 1.0 / 38.0;
   *probptr++ = 0.0;
   printf("                   "
      "Roulette\n");
   printf("Square      Probability "
      "           Total Probability\n");
   probptr = (double *) prob + 1;
   probend = (double *) probptr + 36;
   totprob = 0.0;
   i = 1;
   while (probptr < probend)
      {
      totprob += *probptr;
      printf("%6d %22.17f %22.17f\n",
         i, *probptr, totprob);
      i++;
      probptr++;
      } /* for each straight */
   totprob += *probptr;
   printf("     0 %22.17f %22.17f\n",
      *probptr++, totprob);
   totprob += *probptr;
   printf("    00 %22.17f %22.17f\n",
      *probptr++, totprob);
   printf("\n");
   dblsz = (double) size;
   rootsz = sqrt(dblsz);
   sqptr = (int *) sq;
   sqend = (int *) sq + 48;
   while (sqptr < sqend) *sqptr++ = 0;
   spinptr = (char *) spin;
   spinend = (char *) spin + size;
   while (spinptr < spinend)
      {
      sqptr = (int *) sq + *spinptr++;
      (*sqptr)++;
      } /* for each spin of the wheel */
   dbli = 1.0;
   estx = estxsq = 0.0;
   while (dbli <= 38.0)
      {
      estx   += (dbli / 38.0);
      estxsq += (dbli * dbli / 38.0);
      dbli += 1.0;
      } /* for each square */
   popmu  = estx;
   popvar = estxsq - (estx * estx);
   popstdev = sqrt(popvar);
   std_err  = popstdev / rootsz;
   printf("Square      Wins "
      "       Portion "
      "       Z Score\n");
   sqptr = (int *) sq + 1;
   sqend = (int *) sqptr + 38;
   totportion = 0.0;
   totspin = i = 0;
   expect = dblsz / 38.0;
   while (sqptr < sqend)
      {
      i++;
      dblobs = (double) *sqptr;
      portion = dblobs / dblsz;
      zval = (dblobs - expect) / popstdev;
      if (i < 37)
         printf("%6d %9d %14.6f %14.6f\n",
            i, *sqptr, portion, zval);
      else if (i == 37)
         printf("     0 %9d %14.6f %14.6f\n",
            *sqptr, portion, zval);
      else if (i == 38)
         printf("    00 %9d %14.6f %14.6f\n",
            *sqptr, portion, zval);
      totspin    += *sqptr;
      totportion += portion;
      sqptr++;
      } /* for each square */
   printf(" Total %9d %14.6f\n",
      totspin, totportion);
   printf("\n");
   sumx = sumxsq = sumchi = 0.0;
   sqptr = (int *) sq + 1;
   sqend = (int *) sqptr + 38;
   dbli = 1.0;
   expect = dblsz / 38.0;
   while (sqptr < sqend)
      {
      dblobs = (double) *sqptr;
      sumx   += (dblobs * dbli);
      sumxsq += (dblobs * dbli * dbli);
      diff = dblobs - expect;
      sumchi += (diff * diff / expect);
      dbli += 1.0;
      sqptr++;
      } /* for each square */
   mean = sumx / dblsz;
   variance = (sumxsq - (sumx * sumx / dblsz))
      / (dblsz - 1.0);
   stdev = sqrt(variance);
   zscore = (mean - popmu) / std_err;
   printf("                 Mean "
      "       Stdev "
      "       Z Score\n");
   printf("Population %12.6f %12.6f\n",
      popmu, popstdev);
   printf("Observed   %12.6f %12.6f %12.6f\n",
      mean, stdev, zscore);
   printf("\n");
   chirange(37,&lorange,&hirange); 
   printf("Chi-square %12.6f\n", sumchi);
   printf("Range at 95 Percent: "
      "%10.4f   to %10.4f\n",
      lorange, hirange);
   } /* tally */

int main(argc,argv)
int argc;
char **argv;
   {
   int size;
   char *spinptr;
   char *spinend;
   char *spin;
   unsigned char *sd;
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 30 || size > 1000000)
      {
      fprintf(stderr,"Invalid sample size.\n");
      putstx(*argv);
      } /* bad size */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"roulette: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   spin = (char *) malloc(size + 32);
   if (spin == NULL)
      {
      fprintf(stderr,"roulette: out of memory "
	 "allocating spin.\n");
      exit(1);
      } /* out of mem */
   spinptr = (char *) spin;
   spinend = (char *) spin + size;
   while (spinptr < spinend)
      *spinptr++ = rndnum(38,sd) + 1;
   tally(size,spin);
   return(0);
   } /* main */
