/*
rndfrac2.c - random number generator
	generates random fraction with normal distribution
	from 0.0 to 1.0
	where 0.0 <= x < 1.0
Version 1.7.0
Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Usage:
    	double frac;
    	frac = rndfrac(unsigned char *sd);
*/

/*
Subroutine calls:
	int rnd(unsigned char *sd);
*/

double rndfrac(sd)
unsigned char *sd;
	{
	int i;
	double frac;
	int rnd(unsigned char *sd);
	frac = 0.0;
	i = 52;
	while (i--)
	   {
	   frac = ((frac * 0.5) + ((double) rnd(sd) * 0.5);
	   }
	return(frac);
	} /* rndfrac */
