/*
pwrball.c  Version 1.7.0  Simulate Powerball Drawing
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Subroutine call:
    	int select;
    	int pwrball;
    	double odds;
    	double getpb(int select, int pwrball);
    	odds = getpb(select,pwrball);
*/

/* If the chi-square test fails, repeat your test. */
/* The chi-square usually passes in the next test. */
/* If the chi-square fails consistently, then the */
/* program has to be reviewed for correctness. */

/* The higher the number of iterations, the more */
/* likely the chi-square test will pass.  The chi-square */
/* test needs to have its categories filled with at */
/* least a 10 count in order to pass consistently. */
/* With 100000 iterations, the chi-square test passes */
/* consistently. */

/* See the documentation in pbprob.c regarding the */
/* calls to getpb.c. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

#define PWRBALL 45
#define FORTYFIVE 45
#define FIVE 5
#define P_5_1 0
#define P_5_0 1
#define P_4_1 2
#define P_4_0 3
#define P_3_1 4
#define P_3_0 5
#define P_2_1 6
#define P_1_1 7
#define P_0_1 8
#define MISC  9

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s iterations\n", pgm);
   fprintf(stderr,"Where iterations is 1 - 999999999\n");
   fprintf(stderr,"Example: %s 100000\n", pgm);
   exit(1);
   } /* putstx */

void putlot(int indx,
   int select,
   int pwrball,
   double dblplay,
   double *prizelst,
   double *bingolst,
   double *sumx,
   double *estx,
   double *sumxsqd,
   double *estxsqd,
   double *totprob,
   double *totprize,
   double *totbingo,
   double *sumchi)
   {
   double odds;
   double prob;
   double winning;
   double expected;
   double *prizeptr;
   double *bingoptr;
   double getpb(int select, int pwrball);
   char   title[32];
   odds       = getpb(select,pwrball);
   prob       = 1.0 / odds;
   expected   = dblplay * prob;
   prizeptr   = (double *) prizelst + indx;
   bingoptr   = (double *) bingolst + indx;
   winning    = (*prizeptr) * (*bingoptr);
   *totprob  += prob;
   *totprize += winning;
   *totbingo += *bingoptr;
   *sumx     += (*bingoptr * prob);
   *sumxsqd  += (*bingoptr  *  *bingoptr  *  prob);
   *estx     += (expected * prob);
   *estxsqd  += (expected * expected * prob);
   *sumchi   += (*bingoptr  *  *bingoptr  *  odds);
   sprintf(title,"%d %d", select, pwrball);
   if (expected < 0.01)
      {
      printf("%s   %9.0f  %13.2f  %13.5f   %12.1f\n",
         title, *bingoptr, winning, expected, odds);
      } /* if expected isn't printable */
   else
      {
      printf("%s   %9.0f  %13.2f  %13.2f   %12.1f\n",
         title, *bingoptr, winning, expected, odds);
      } /* else expected is printable */
   } /* putlot */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,max45,indx;
   unsigned char *p,*q,*r;
   unsigned char *gameptr;
   unsigned char *trialptr;
   unsigned char fortyfive[64];
   unsigned char winners[64];
   unsigned char game[16];
   unsigned char trial[16];
   int tmp;
   int gamepb;
   int winpb;
   int totmtch,won;
   int totplay;
   int maxplay;
   double prob,dblplay;
   double winning,totprize,netearn;
   double prize[16];
   double odds,sumchi,totbingo,chisq;
   double totprob;
   double expected;
   double mean;
   double variance;
   double stdev;
   double popmean;
   double popvar;
   double popstdev;
   double sumx;
   double estx;
   double sumxsqd;
   double estxsqd;
   double zscore;
   double getpb(int select, int pwrball);
   double *bingoptr;
   double bingo[16];
   if (argc != 2) putstx(*argv);
   maxplay = atoi(*(argv+1));
   if (maxplay < 1 || maxplay > 999999999)
      {
      fprintf(stderr,"Invalid iterations\n");
      putstx(*argv);
      }
   sd = (unsigned char *) rndinit();
   prize[P_5_1] = 5000000.00;
   prize[P_5_0] = 100000.00;
   prize[P_4_1] = 5000.00;
   prize[P_4_0] = 100.00;
   prize[P_3_1] = 100.00;
   prize[P_3_0] = 5.00;
   prize[P_2_1] = 5.00;
   prize[P_1_1] = 2.00;
   prize[P_0_1] = 1.00;
   p = (unsigned char *) fortyfive;
   q = (unsigned char *) fortyfive + FORTYFIVE;
   i = 0;
   while (p < q)
      *p++ = (unsigned char) ++i;
   *p = (unsigned char) '\0';
   p = (unsigned char *) winners;
   q = (unsigned char *) winners + FORTYFIVE;
   while (p < q)
      *p++ = (unsigned char) '\0';
   p = (unsigned char *) fortyfive;
   q = (unsigned char *) fortyfive + FORTYFIVE - 1;
   r = (unsigned char *) winners;
   gameptr = (unsigned char *) game;
   i = 0;
   max45 = FORTYFIVE;
   while (i < FIVE)
      {
      indx = rndnum(max45,sd);
      tmp = *(p+indx);
      *(r+tmp)   = (unsigned char) 255;
      *gameptr++ = (unsigned char) tmp;
      *(p+indx) = *q;
      *q-- = '\0';
      max45--;
      i++;
      } /* pick 5 balls without replacement */
   gamepb = rndnum(PWRBALL,sd) + 1;
   printf("Powerball:  ");
   gameptr = (unsigned char *) game;
   i = FIVE;
   while (i--)
      {
      printf("%2d ", (int) *gameptr++);
      } /* print 5 winning balls */
   printf("- %2d\n\n", gamepb);
   printf("Match      Wins          Prize    "
      "   Expected           Odds\n");
   bingoptr = (double *) bingo;
   i = 9;
   while (i--) *bingoptr++ = 0.0;
   bingoptr = (double *) bingo;
   totplay = maxplay;
   while (totplay--)
      {
      p = (unsigned char *) fortyfive;
      q = (unsigned char *) fortyfive + FORTYFIVE;
      i = 0;
      while (p < q)
         *p++ = (unsigned char) ++i;
      *p = (unsigned char) '\0';
      totmtch = winpb = 0;
      p = (unsigned char *) fortyfive;
      q = (unsigned char *) fortyfive + FORTYFIVE - 1;
      r = (unsigned char *) winners;
      trialptr = (unsigned char *) trial;
      max45 = FORTYFIVE;
      i = FIVE;
      while (i--)
         {
         indx = rndnum(max45,sd);
         tmp = (int) *(p+indx);
         *trialptr++ = (unsigned char) tmp;
         if (*(r+tmp) == 255) totmtch++;
         *(p+indx) = *q;
         *q-- = '\0';
         max45--;
         } /* pick 5 balls without replacement */
      winpb = rndnum(PWRBALL,sd) + 1;
      if (winpb != gamepb) winpb = 0;
      won = 999999;
      if (totmtch == FIVE)
         {
         if (winpb) won = 0;
         else won = 1;
         } /* select 5 */
      else if (totmtch == 4)
         {
         if (winpb) won = 2;
         else won = 3;
         } /* select 4 */
      else if (totmtch == 3)
         {
         if (winpb) won = 4;
         else won = 5;
         } /* select 3 */
      else if (totmtch == 2 && winpb)
         won = 6;
      else if (totmtch == 1 && winpb)
         won = 7;
      else if (totmtch == 0 && winpb)
         won = 8;
      else won = 9;
      *(bingoptr+won) += 1.0;
      } /* tst loop maxplay times */

   sumx = estx = sumxsqd = estxsqd =
   totprob = totprize = totbingo = sumchi = 0.0;
   dblplay = (double) maxplay;

   putlot(P_5_1, 5, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_5_0, 5, 0,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_4_1, 4, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_4_0, 4, 0,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_3_1, 3, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_3_0, 3, 0,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_2_1, 2, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_1_1, 1, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   putlot(P_0_1, 0, 1,
      dblplay, prize, bingo,
      &sumx, &estx, &sumxsqd, &estxsqd,
      &totprob, &totprize, &totbingo, &sumchi);

   prob     = 1.0 - totprob;
   odds     = 1.0 / prob;
   winning  = dblplay - totbingo;
   expected = dblplay * prob;
   estx    += (expected * prob);
   estxsqd += (expected * expected * prob);
   sumx    += (winning * prob);
   sumxsqd += (winning * winning * prob);
   sumchi  += (winning * winning * odds);
   printf("0 0   %9.0f  %13.2f  %13.2f   %21.10f\n",
      winning,
      0.0,
      expected,
      odds);
   printf("        -------      ---------\n");
   printf("Total %9.0f  %13.2f\n\n",
      dblplay, totprize);
   printf("Total Cost       %13.2f\n\n",
      dblplay);
   netearn = totprize - dblplay;
   printf("Net Income       %13.2f\n\n",
      netearn);

   printf("                 Mean "
      "            "
      "Stdev "
      "       "
      "Z Score\n");
   popmean  = estx;
   popvar   = estxsqd - (popmean * popmean);
   popstdev = sqrt(popvar);
   mean     = sumx;
   variance = sumxsqd - (mean * mean);
   stdev    = sqrt(variance);
   zscore   = (mean - popmean) / (popstdev / sqrt(dblplay));
   printf("Expected %16.6f %16.6f\n",
      popmean, popstdev);
   printf("Observed %16.6f %16.6f %10.4f\n",
      mean, stdev, zscore);
   printf("\n");
   chisq = (sumchi / dblplay) - dblplay;
   printf("Chi-square %f\n", chisq);
   /* 9 degrees of freedom */
   printf("Range at 95 percent "
      "is 2.70039 to 19.0228\n");
   return(0);
   } /* main */
