/*
meandfsz.c Version 1.7.0 - Difference between 2 means:
calculate the estimated sample size
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 9, Statistical Estimation */
/* Section 2, Inverval Estimation About Means */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* meandfsz -c 95.0 -s 10000 -f -n 100 -p 0.5 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s options\n",
      pgm);
   fprintf(stderr,"Options:\n");
   fprintf(stderr,"-h help\n");
   fprintf(stderr,"-c cc.c = confidence level\n");
   fprintf(stderr,"   where cc.c is 90.0, 95.0, "
      "98.0, or 99.0\n");
   fprintf(stderr,"   default = 95.0\n");
   fprintf(stderr,"-e ee.e = error of estimation\n");
   fprintf(stderr,"   where ee.e is 0.001 to 10.0\n");
   fprintf(stderr,"   default = 0.01\n");
   fprintf(stderr,"-p n.n = probability of success\n");
   fprintf(stderr,"   where n.n = 0.001 - 0.999\n");
   fprintf(stderr,"   default = 0.5\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i;
   int size;
   int rslt;
   double confidence;
   double esterr;
   double tstprob;
   int getn(double confidence, double esterr,
      double tstprob);
   if (argc == 1) putstx(*argv);
   confidence = 95.0;
   esterr  = 0.01;
   tstprob = 0.5;
   i = 1;
   while (i < argc)
      {
      rslt = strcmp(*(argv+i),"-h");
      if (!rslt) putstx(*argv);
      rslt = strcmp(*(argv+i),"-c");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing confidence level\n");
	    putstx(*argv);
	    } /* if out of arguments */
         confidence = atof(*(argv+i));
         if (confidence == 90.0 || confidence == 95.0
            || confidence == 98.0 || confidence == 99.0);
	 else
            {
            fprintf(stderr,"Invalid confidence level.\n");
            putstx(*argv);
            } /* bad confidence */
	 i++;
	 continue;
	 } /* if confidence level */
      rslt = strcmp(*(argv+i),"-e");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing error of estimation\n");
	    putstx(*argv);
	    } /* if out of arguments */
         esterr = atof(*(argv+i));
         if (esterr < 0.001 || esterr > 10.0)
            {
            fprintf(stderr,"Invalid error of estimation\n");
            putstx(*argv);
            } /* bad error of estimation */
	 i++;
	 continue;
	 } /* if error of estimation */
      rslt = strcmp(*(argv+i),"-p");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing probability\n");
	    putstx(*argv);
	    } /* if out of arguments */
         tstprob = atof(*(argv+i));
         if (tstprob < 0.001 || tstprob > 0.999)
            {
            fprintf(stderr,"Invalid probability.\n");
            putstx(*argv);
            } /* bad tstprob */
	 i++;
	 continue;
	 } /* if probability */
      fprintf(stderr,"Invalid option %s.\n",
	 *(argv+i));
      putstx(*argv);
      } /* for each argument */
   size = getn(confidence, esterr, tstprob);
   printf("Sample size is %d\n", size);
   return(0);
   } /* main */
