/*
maxt.c Version 1.7.0 - Maximum of t Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

/* The Kolmogorof-Smirnov test is based on */
/* Numerical Recipes in C, Chapter 14.3 */
/* ksone and probks */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s t n\n", pgm);
   fprintf(stderr,"Where t is  1 -   100\n");
   fprintf(stderr,"      n is 10 - 10000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int t,n;
   double *data;
   double *p,*q;
   double maxt;
   double kplus,kminus;
   double negtblv,postblv;

   if (argc != 3) putstx(*argv);
   t = atoi(*(argv+1));
   if (t < 1 || t > 100)
      {
      fprintf(stderr,"Invalid t\n");
      putstx(*argv);
      } /* invalid t */
   n = atoi(*(argv+2));
   if (n < 10 || n > 10000)
      {
      fprintf(stderr,"Invalid n\n");
      putstx(*argv);
      } /* invalid n */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"maxt: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of memory */
   data = (double *) malloc(n * sizeof(double)+32);
   if (data == NULL)
      {
      fprintf(stderr,"maxt: out of memory "
	 "allocating array V\n");
      exit(1);
      } /* out of memory */
   p = data;
   q = data + n;
   while (p < q) *p++ = 0.0;

   j = 0;
   while (j++ < n)
      {
      double tmp,hld;
      i = 0;
      maxt = 0.0;
      while (i++ < t)
         {
         tmp = rndfrac(sd);
         if (tmp > maxt) maxt = tmp;
         } /* for each i until t */
      p = data;
      q = data + n;
      while (*p && p < q && maxt > *p) p++;
      if (p >= q)
         {
         fprintf(stderr,"Overflow\n");
         exit(1);
         } /* overflow */
      hld = *p;
      *p++ = maxt;
      while (p < q && *p > 0.0)
         {
         tmp = *p;
         *p++ = hld;
         hld = tmp;
         } /* shift right */
      *p = hld;
      } /* for each x in data */

   kplus = kminus = -999999999.0;
   j = 0;
   while (j < n)
      {
      double tmp,diffp,diffm;
      tmp = (double) pow(data[j],(double) t);
      diffp = (double) ((double) (j+1.0)
         / (double) n) - tmp;
      if (diffp > kplus) kplus = diffp;
      diffm = tmp - (double) ((double) j
         / (double) n);
      if (diffm > kminus) kminus = diffm;
      j++;
      } /* print data */

   kplus *= sqrt(n);
   printf("kplus  %d  %f\n", n, kplus);
   kminus *= sqrt(n);
   printf("kminus %d  %f\n", n, kminus);
   ksrange(n,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);

   return(0);
   } /* main */
