/*
ksrange.c Version 1.7.0 - Calculate Percent in Table 2
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This calculation is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.1, General Test Procedures */
/* Kolmogorov-Smirnov Test, Table 2 */
/* Some numbers not in Table 2 have */
/* been interpolated. */
/* All numbers have been chosen for the */
/* 1% and 99% tails of the distribution. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void ksrange(degf,lowrange,hirange)
int degf;
double *lowrange,*hirange;
   {
   double v;
   double ypsq;
   double lotbl[31] = {0.0, 0.01, 0.014, 0.01699,
      0.01943, 0.02152, 0.02336, 0.02501, 0.02650,
      0.02786, 0.02912, 0.03028, 0.03137,
      0.03232666667, 0.033283333333, 0.03424,
      0.035006, 0.035772, 0.036538, 0.037304, 0.03807,
      0.038617, 0.039164, 0.039711, 0.040258, 0.040805,
      0.041352, 0.041899, 0.042446, 0.042993, 0.04354 };
   double hitbl[31] = {0.0, 0.99, 1.2728, 1.3589,
      1.3777, 1.4024, 1.4144, 1.4246, 1.4327,
      1.4388, 1.4440, 1.4484, 1.4521,
      1.45493333, 1.457766667, 1.4606,
      1.46244, 1.46428, 1.46612, 1.46796, 1.4698,
      1.47083, 1.47186, 1.47289, 1.47392, 1.47495,
      1.47598, 1.47701, 1.47804, 1.47907, 1.4801 };
   if (degf < 1 || degf > 999999)
      {
      fprintf(stderr,"ksrange: invalid "
         "degree of freedom %d\n", degf);
      exit(1);
      } /* bad degf */
   if (degf < 31)
      {
      *lowrange = lotbl[degf];
      *hirange  = hitbl[degf];
      return;
      } /* if low deg of freedom */
   v = (double) degf;
   /* for large degrees of freedom > 30 */
   ypsq = 0.5 * log(1.0 / 0.95);
   *lowrange = sqrt(ypsq)
      - (1.0 / (6.0 * sqrt(v)))
      + 0.003;
   ypsq = 0.5 * log(1.0 / 0.05);
   *hirange = sqrt(ypsq)
      - (1.0 / (6.0 * sqrt(v)));
   return;
   } /* ksrange */
