/*
getttbl.c Version 1.7.0 - Look up the t value in
the t table for a 2 tail test at 95 percent
or a 1 tail test at 97.5 percent
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* The following density function was obtained */
/* from:                                       */
/* Standard Mathematical Tables                */
/* Percentage Points, Student's T Distribution */

/*   F(t) = integral(-inf to t) expression dx          */

/*   expression = (gamma_ratio * power_exp)            */

/*   gamma_ratio = gamma_top / (pi_root * gamma_bot)   */

/*   gamma_top = gamma((n + 1) / 2)                    */

/*   pi_root   = sqrt(n * pi)                          */

/*   gamma_bot = gamma(n / 2)                          */

/*   power_exp = (1 + (x * x / n)) ^ -((n+1)/2)        */

/*   n = 1 to 30, 40, 60, 120, inf (degrees of freedom) */

/* see info libc for information about */
/* lgamma */

/* It is assumed in this program that degrees of */
/* freedom are the same for both standard deviations. */

/* This program is usually called once per host */
/* program execution. */

#include <stdio.h>
#include <stdlib.h>

double getttbl(int degf)
   {
   double f;
   double frac;
   double diff;
   double delta;
   double tbl[40] = {0.0,  /* 0 */
       12.706,      /*  1  */
        4.303,      /*  2  */
        3.182,      /*  3  */
        2.776,      /*  4  */
        2.571,      /*  5  */
        2.447,      /*  6  */
        2.365,      /*  7  */
        2.306,      /*  8  */
        2.262,      /*  9  */
        2.228,      /* 10  */
        2.201,      /* 11  */
        2.179,      /* 12  */
        2.160,      /* 13  */
        2.145,      /* 14  */
        2.131,      /* 15  */
        2.120,      /* 16  */
        2.110,      /* 17  */
        2.101,      /* 18  */
        2.093,      /* 19  */
        2.086,      /* 20  */
        2.080,      /* 21  */
        2.074,      /* 22  */
        2.069,      /* 23  */
        2.064,      /* 24  */
        2.060,      /* 25  */
        2.056,      /* 26  */
        2.052,      /* 27  */
        2.048,      /* 28  */
        2.045,      /* 29  */
        2.042,      /* 30  */
      -99.99 };     /* end */
   if (degf < 1)
      {
      fprintf(stderr,"getttbl: invalid "
         "degree of freedom %d\n", degf);
      exit(1);
      } /* bad degf */
   else if (degf > 30 && degf <= 40)
      {
      frac  = ((double) degf - 30.0) / 10.0;
      diff  = 2.042 - 2.021;
      delta = diff - (frac * diff);
      f = 2.021 + delta;
      return(f);
      } /* if 30-40 deg of freedom */
   else if (degf > 40 && degf <= 60)
      {
      frac = ((double) degf - 40.0) / 20.0;
      diff  = 2.021 - 2.000;
      delta = diff - (frac * diff);
      f = 2.000 + delta;
      return(f);
      } /* if 40-60 deg of freedom */
   else if (degf > 60 && degf <= 120)
      {
      frac = ((double) degf - 60.0) / 60.0;
      diff  = 2.000 - 1.980;
      delta = diff - (frac * diff);
      f = 1.980 + delta;
      return(f);
      } /* if 60-120 deg of freedom */
   else if (degf > 120)
      {
      frac = 120.0 / (double) degf;
      diff  = 1.980 - 1.960;
      delta = frac * diff;
      f = 1.960 + delta;
      return(f);
      } /* if infinite deg of freedom */
   else if (degf < 31)
      {
      f = tbl[degf];
      return(f);
      } /* if 1-30 deg of freedom */
   fprintf(stderr,"getttbl: invalid "
      "degree of freedom %d\n", degf);
   exit(1);
   } /* getttbl */
