/*
getn.c  Version 1.7.0 Calculate Sample Size
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Subroutine call:
    	double confidence;
    	double errrate;
    	double psuccess;
    	int size;
    	size = getn(confidence,errrate,psuccess);

        Where:
	confidence is 90.0, 95.0, 98.0, 99.0
	errrate is 0.0 < e < 1.0 
	psuccess is 0.1 to 0.9

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int getn(double confidence, double errrate,
   double psuccess)
   {
   int size;
   double zval;
   double variance;
   double zsqd;
   double esqd;
   if (confidence == 90.0)
      {
      zval = 1.645;
      } /* if 90% confidence */
   else if (confidence == 95.0)
      {
      zval = 1.96;
      } /* if 95% confidence */
   else if (confidence == 98.0)
      {
      zval = 2.326;
      } /* if 98% confidence */
   else if (confidence == 99.0)
      {
      zval = 2.575;
      } /* if 99% confidence */
   else
      {
      fprintf(stderr,"getn: confidence %f is "
	 "not correct\n", confidence);
      fprintf(stderr,"Correct values are "
	 "90.0, 95.0, 98.0, 99.0\n");
      exit(1);
      } /* if invalid confidence */
   if (errrate < 0.001 || errrate > 10.0)
      {
      fprintf(stderr,"getn: error rate %f is "
	 "out of range\n", errrate);
      fprintf(stderr,"Error rate is "
	 "0.01 to 0.1\n");
      exit(1);
      } /* if invalid error rate */
   if (psuccess < 0.001 || psuccess > 0.999)
      {
      fprintf(stderr,"getn: probability of "
	 "success %f is out of range\n", psuccess);
      fprintf(stderr,"Probability of success is "
	 "0.1 to 0.9\n");
      exit(1);
      } /* if invalid probability */
   variance = psuccess * (1.0 - psuccess);
   zsqd = zval * zval;
   esqd = errrate * errrate;
   size = (int) floor((variance * zsqd / esqd) + 0.999999);
   if (size < 30)
      {
      fprintf(stderr,"getn: size %d "
	 "is too small\n", size);
      fprintf(stderr,"Size should be "
	 "from 30 to 2000000\n");
      fprintf(stderr,"Adjust confidence level "
	 "or error rate\n");
      exit(1);
      } /* if size too small */
   if (size > 2000000)
      {
      fprintf(stderr,"getn: size %d "
	 "is too large\n", size);
      fprintf(stderr,"Size should be "
	 "from 30 to 2000000\n");
      fprintf(stderr,"Adjust confidence level "
	 "or error rate\n");
      exit(1);
      } /* if size too large */
   return(size);
   } /* getn */
