/*
getftbl.c Version 1.7.0 - Look up the f value in
the f table for a 2 tail test at 95 percent
or a 1 tail test at 97.5 percent
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This table is based on */
/* Standard Mathematical Tables                */
/* Percentage Points, F Distribution           */

/*   F(F) = integral(0 to F) expression dx          */

/*   expression = (gamma_ratio * power_exp)            */

/*   gamma_ratio = gamma_top / gamma_bot               */

/*   gamma_top = gamma((m + n) / 2)                    */

/*   gamma_bot = gamma(m / 2) * gamma(n / 2)           */

/*   power_exp = m_pwr * n_pwr * x_pwr * nmx_pwr       */

/*   m_pwr     = m ^ (m / 2)                           */

/*   n_pwr     = n ^ (n / 2)                           */

/*   x_pwr     = x ^ ((m - 2) / 2)                     */

/*   nmx_pwr   = (n + mx) ^ (-(n + m) / 2)             */

/*   m = 1 to 30, 40, 60, 120, inf (degrees of freedom) */

/*   n = 1 to 30, 40, 60, 120, inf (degrees of freedom) */

/* see info libc for information about */
/* lgamma */

/* It is assumed in this program that degrees of */
/* freedom are the same for both standard deviations. */

/* This program is usually called once per host */
/* program execution. */

#include <stdio.h>
#include <stdlib.h>

double getftbl(int degf)
   {
   double f;
   double frac;
   double diff;
   double delta;
   double tbl[40] = {0.0,  /* 0 */
      647.8,        /*  1,1 */
       39.00,       /*  2,2 */
       15.44,       /*  3,3 */
        9.60,       /*  4,4 */
        7.15,       /*  5,5 */
        5.82,       /*  6,6 */
        4.99,       /*  7,7 */
        4.43,       /*  8,8 */
        4.03,       /*  9,9 */
        3.72,       /* 10,10 */
        3.47,       /* 11,11 */
        3.28,       /* 12,12 */
        3.12,       /* 13,13 */
        2.98,       /* 14,14 */
        2.86,       /* 15,15 */
        2.76,       /* 16,16 */
        2.67,       /* 17,17 */
        2.60,       /* 18,18 */
        2.53,       /* 19,19 */
        2.46,       /* 20,20 */
        2.41,       /* 21,21 */
        2.36,       /* 22,22 */
        2.31,       /* 23,23 */
        2.27,       /* 24,24 */
        2.23,       /* 25,25 */
        2.19,       /* 26,26 */
        2.16,       /* 27,27 */
        2.13,       /* 28,28 */
        2.10,       /* 29,29 */
        2.07,       /* 30,30 */
      -99.99 };     /* end */
   if (degf < 1)
      {
      fprintf(stderr,"getftbl: invalid "
         "degree of freedom %d\n", degf);
      exit(1);
      } /* bad degf */
   else if (degf > 30 && degf <= 40)
      {
      frac  = ((double) degf - 30.0) / 10.0;
      diff  = 2.07 - 1.88;
      delta = diff - (frac * diff);
      f = 1.88 + delta;
      return(f);
      } /* if 40 deg of freedom */
   else if (degf > 40 && degf <= 60)
      {
      frac  = ((double) degf - 40.0) / 20.0;
      diff  = 1.88 - 1.67;
      delta = diff - (frac * diff);
      f = 1.67 + delta;
      return(f);
      } /* if 60 deg of freedom */
   else if (degf > 60 && degf <= 120)
      {
      frac  = ((double) degf - 60.0) / 60.0;
      diff  = 1.67 - 1.43;
      delta = diff - (frac * diff);
      f = 1.43 + delta;
      return(f);
      } /* if 120 deg of freedom */
   else if (degf > 120)
      {
      frac = 120.0 / (double) degf;
      diff  = 1.43 - 1.00;
      delta = frac * diff;
      f = 1.00 + delta;;
      return(f);
      } /* if infinite deg of freedom */
   else if (degf < 31)
      {
      f = tbl[degf];
      return(f);
      } /* if 1-30 deg of freedom */
   fprintf(stderr,"getftbl: invalid "
      "degree of freedom %d\n", degf);
   exit(1);
   } /* getftbl */
