/*
flip.c Version 1.7.0 - Coin Flip Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* flip 100000 12 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size flips\n",
      pgm);
   fprintf(stderr,"Where size is 1000 to 1000000000\n");
   fprintf(stderr,"Where flips is 2 to 30\n");
   fprintf(stderr,"Example: %s 10000 20\n", pgm);
   fprintf(stderr,"Size is more than 100 times larger "
      "than flips\n");
   fprintf(stderr,"Usage: %s options\n",
      pgm);
   fprintf(stderr,"Options:\n");
   fprintf(stderr,"-s zzzzzz = size of test\n");
   fprintf(stderr,"   where zzzzzz is 30 to 1000000000\n");
   fprintf(stderr,"   default = 10000\n");
   fprintf(stderr,"-f dd = number of coin flips\n");
   fprintf(stderr,"   where dd = 2 - 30\n");
   fprintf(stderr,"   default = 17\n");
   fprintf(stderr,"-g ddd = number of skip cycles\n");
   fprintf(stderr,"   where dd = 0 - 100\n");
   fprintf(stderr,"   default = 0\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int rslt;
   int i,j;
   int size,flips;
   int gap;
   int skip;
   int heads;
   int min;
   int max;
   int *obs;
   int *obsptr;
   int *obsend;
   double *p,*q;
   double *prob;
   double *probptr;
   double totprob;
   double dblheads;
   double bottom,top;
   double zval;
   double zscore;
   double dbli;
   double dblobs;
   double mu,musq;
   double popmu;
   double popvar;
   double popstdev;
   double est_xsq;
   double expect;
   double variance,stdev;
   double diff;
   double sumchi;
   double dblsz;
   double sumx,sumxsqd;
   double negtblv,postblv;
   double combo(int n, int r);
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc == 1) putstx(*argv);
   size = 10000;
   dblsz = (double) size;
   flips = 17;
   gap   = 0;
   i = 1;
   while (i < argc)
      {
      rslt = strcmp(*(argv+i),"-h");
      if (!rslt) putstx(*argv);
      rslt = strcmp(*(argv+i),"-s");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing number "
	       "for option -s\n");
	    putstx(*argv);
	    } /* if out of arguments */
         size = atoi(*(argv+i));
         if (size < 30 || size > 100000)
            {
            fprintf(stderr,"Invalid size %s.\n",
	       *(argv+i));
            putstx(*argv);
            } /* bad size */
         dblsz = (double) size;
	 i++;
	 continue;
	 } /* if size */
      rslt = strcmp(*(argv+i),"-f");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing number "
	       "for option -f\n");
	    putstx(*argv);
	    } /* if out of arguments */
         flips = atoi(*(argv+i));
         if (flips < 2 || flips > 30)
            {
            fprintf(stderr,"Invalid flips %s.\n",
	       *(argv+i));
            putstx(*argv);
            } /* bad flips */
	 i++;
	 continue;
	 } /* if flips */
      rslt = strcmp(*(argv+i),"-g");
      if (!rslt)
	 {
	 i++;
	 if (i >= argc)
	    {
	    fprintf(stderr,"Missing number "
	       "for option -g\n");
	    putstx(*argv);
	    } /* if out of arguments */
         gap = atoi(*(argv+i));
         if (gap < 0 || gap > 100)
            {
            fprintf(stderr,"Invalid gap %s.\n",
	       *(argv+i));
            putstx(*argv);
            } /* bad gap */
	 i++;
	 continue;
	 } /* if gap */
      fprintf(stderr,"Invalid option %s.\n",
	 *(argv+i));
      putstx(*argv);
      } /* for each argument */
   if (size < flips * 100)
      {
      fprintf(stderr,"Size is too small.\n");
      putstx(*argv);
      } /* if size too small */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"flip: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   obs = (int *) malloc((flips + 1) * sizeof(int) + 32);
   if (obs == NULL)
      {
      fprintf(stderr,"flip: out of memory "
	 "allocating observation array.\n");
      exit(1);
      } /* out of memory */
   prob = (double *) malloc((flips + 1) * sizeof(double) + 32);
   if (prob == NULL)
      {
      fprintf(stderr,"flip: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   bottom = pow(2.0,(double) flips);
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      top = combo(flips,i);
      *p = top / bottom;
      i++;
      p++;
      } /* for each # of heads */
   popmu = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      popmu += ((double) i * *p++);
      i++;
      } /* for each # of heads */
   musq = popmu * popmu;
   est_xsq = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      est_xsq += ((double) (i * i) * *p++);
      i++;
      } /* for each # of heads */
   popvar   = est_xsq -  musq;
   popstdev = sqrt(popvar);
   printf("Probability Distribution\n");
   printf("x = number of heads "
      "after flipping %d coins\n",
      flips);
   printf(" x    P(x) "
      "                  "
      "Total P(x)             z\n");
   totprob = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      dbli = (double) i;
      zval = (dbli - popmu) / popstdev;
      totprob += *p;
      printf("%2d %22.17f %22.17f %9.4f\n",
	 i, *p, totprob, zval);
      i++;
      p++;
      } /* for each # of heads */
   printf("\n");
   printf("             Mean       Variance "
      "  Stdev      Z Score      Min     Max\n");
   printf("Population %10.6f %10.6f %10.6f\n",
      popmu, popvar, popstdev);
   obsptr = (int *) obs;
   obsend = (int *) obsptr + flips + 1;
   while (obsptr < obsend) *obsptr++ = 0;
   sumx = sumxsqd = 0.0;
   min =  999999999;
   max = -999999999;
   i = size;
   while (i--)
      {
      heads = j = 0;
      while (j < flips)
	 {
	 heads += (int) rnd(sd);
	 if (gap > 0)
	    {
	    skip = gap;
	    while (skip--) rnd(sd);
	    } /* if skip cycles */
	 j++;
	 } /* for each flip */
      obsptr = (int *) obs + heads;
      (*obsptr)++;
      dblheads = (double) heads;
      sumx    += dblheads;
      sumxsqd += (dblheads * dblheads);
      if (heads < min) min = heads;
      if (heads > max) max = heads;
      } /* generate histogram */
   variance = (sumxsqd - (sumx * sumx / dblsz))
      / (dblsz - 1.0);
   stdev = sqrt(variance);
   sumchi = mu = 0.0;
   i = 0;
   obsptr = (int *) obs;
   obsend = (int *) obsptr + flips + 1;
   probptr = (double *) prob;
   while (obsptr < obsend)
      {
      dbli   = (double) i++;
      dblobs = (double) *obsptr++;
      mu += (dblobs * dbli / dblsz);
      expect = (*probptr++) * dblsz;
      diff = dblobs - expect;
      sumchi += (diff * diff / expect);
      } /* sum chi-sq */
   zscore = (mu - popmu) / (popstdev / sqrt(dblsz));
   printf("Observed   %10.6f %10.6f %10.6f %10.6f %7d %7d\n",
      mu, variance, sqrt(variance), zscore, min, max);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(flips,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
