/*
equdis.c Version 1.7.0 - Equidistribution Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n", pgm);
   fprintf(stderr,"Where size  is 10 - 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,n,j,size;
   double tmp,hld;
   double kplus,kminus;
   double diffp,diffm,absdiff;
   double dblj,dbln;
   double negtblv,postblv;
   double *data;
   double *p,*q;
   double sqrt();
   double root;
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 10 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   data = (double *) malloc(size * sizeof(double) + 32);
   if (data == NULL)
      {
      fprintf(stderr,"equdis: out of memory "
	 "allocating KS array V\n");
      exit(1);
      } /* out of memory */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"equdis: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of memory */
   p = data;
   q = data + size;
   while (p < q) *p++ = 0.0;
   i = 0;
   p = data;
   q = data + size;
   while (i++ < size)
      {
      tmp = rndfrac(sd);
      p = data;
      q = data + size;
      while (*p && p < q && tmp > *p) p++;
      if (p >= q)
         {
         fprintf(stderr,"Overflow\n");
         exit(1);
         } /* overflow */
      hld = *p;
      *p++ = tmp;
      while (p < q && *p > 0.0)
         {
         tmp = *p;
         *p++ = hld;
         hld = tmp;
         } /* shift right */
      *p = hld;
      } /* fill data */

   kplus = kminus = -999999999.0;
   n = size;
   dbln = (double) n;
   j = 0;
   while (j < n)
      {
      tmp = data[j];   /* F(x) */
      dblj = (double) j++;
      diffp = (double) ((dblj+1.0)
         / dbln) - tmp;
      absdiff = fabs(diffp);
      if (absdiff > kplus) kplus = absdiff;
      diffm = (double) tmp - (dblj / dbln);
      absdiff = fabs(diffm);
      if (absdiff > kminus) kminus = absdiff;
      } /* print data */

   root = sqrt(dbln);
   kplus *= root;
   printf("kplus  %d  %f\n", n, kplus);

   kminus *= root;
   printf("kminus %d  %f\n", n, kminus);
   ksrange(n,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);

   return(0);
   } /* main */
