/*
combo.c  Version 1.7.0 Calculate Combination
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Subroutine call:
    	int n;
    	int r;
    	double rslt;
    	rslt = combo(n,r);

        Where:

	The number of combinations of r objects from
	a set of n objects =

              CCCC
             C       N                         n!
             C            = C(n,r) =     ------------
             C       R                    (n-r)! (r)!
              CCCC
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double combo(int n, int r)
   {
   double dbln;
   double dblr;
   double tmpn;
   double lmt;
   double n_r;
   double bot_fact;
   double rslt;
   double top;
   double bottom;
   if (n < 0)
      {
      fprintf(stderr,"combo: n %d is "
	 "negative\n", n);
      exit(1);
      } /* if invalid n */
   else if (n > 999)
      {
      fprintf(stderr,"combo: n %d is "
	 "too large\n", n);
      exit(1);
      } /* if invalid n */
   else if (r < 0)
      {
      fprintf(stderr,"combo: r %d is "
	 "negative\n", r);
      exit(1);
      } /* if invalid r */
   else if (n < r)
      {
      fprintf(stderr,"combo: r %d is "
	 "larger than n %d\n", r, n);
      exit(1);
      } /* if invalid r */
   dbln = (double) n;
   dblr = (double) r;
   n_r = dbln - dblr;
   if (n_r > dblr)
      {
      lmt = n_r;
      bot_fact = dblr;
      } /* if n_r > dblr */
   else
      {
      lmt = dblr;
      bot_fact = n_r;
      } /* if dblr >= n_r */
   top  = 1.0;
   tmpn = dbln;
   while (tmpn > lmt)
      {
      top *= tmpn--;
      } /* for n - r + 1 */
   bottom  = 1.0;
   while (bot_fact > 1.0)
      {
      bottom *= bot_fact--;
      } /* factorial of divisor */
   rslt = top / bottom;
   return(rslt);
   } /* combo */
