/*
binchi.c Version 1.7.0 - Binary Subsequence Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

/* sample test: */

/* binchi 12 4 8 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s log2size log2cat interval\n",
      pgm);
   fprintf(stderr,"Where log2size is 10 to 20\n");
   fprintf(stderr,"      log2cat is 1 to 5\n");
   fprintf(stderr,"      interval   is 1 - 16384\n");
   fprintf(stderr,"Size is more than 10 times larger "
      "than categories\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,size,cats,intvl,urns;
   int tmp;
   double t;
   double *p,*q,*r;
   double rslt;
   double negtblv,postblv;
   if (argc != 4) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 1 || size > 20)
      {
      fprintf(stderr,"Invalid log2size.\n");
      putstx(*argv);
      } /* bad size */
   cats = atoi(*(argv+2));
   if (cats < 1)
      {
      fprintf(stderr,"Log2cat is too small.\n");
      putstx(*argv);
      } /* not enough cats */
   if (cats > 5)
      {
      fprintf(stderr,"Log2cat is too large.\n");
      putstx(*argv);
      } /* if cats too large */
   if (size < cats + 4)
      {
      fprintf(stderr,"Log2size is too small.\n");
      putstx(*argv);
      } /* if size too small */
   intvl = atoi(*(argv+3));
   if (intvl < 1 || intvl > 16384)
      {
      fprintf(stderr,"Invalid interval.\n");
      putstx(*argv);
      } /* bad interval */
   size = 1 << size;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"binchi: out of "
	 "memory allocating sd.\n");
      exit(1);
      } /* out of memory */
   urns = 1 << cats;
   r = (double *) malloc(urns * sizeof(double) + 32);
   if (r == NULL)
      {
      fprintf(stderr,"binchi: out of "
	 "memory allocating r.\n");
      exit(1);
      } /* out of memory */
   p = r;
   q = p + urns;
   while (p < q) *p++ = 0.0;
   i = 0;
   while (i++ < size)
      {
      p = r + rndpwr(cats,sd);
      *p += 1.0;
      j = 0;
      while (j++ < intvl)
         tmp = rndpwr(cats,sd);
      } /* generate histogram */
   i = 0;
   t = 0.0;
   p = r;
   while (i++ < urns)
      {
      t += ((*p) * (*p));
      /* printf("%9d %15.0f %15.0f\n", i, *p, t); */
      p++;
      } /* calc chi sq */
   rslt = (double) ((((double) urns * t)
      / (double) size) - (double) size);
   printf("%f\n", rslt);
   chirange(urns-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
