#!/usr/bin/make

# nonintel.mak - compile program datagen (Data Generator)
# for non-Intel platform
# Version 1.7.0
# Copyright (C) 1999-2010   dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

# Makefile for non-Intel platforms:
# Source file rnd2.c    is used instead of rnd.s
# Source file rndpwr2.c is used instead of rndpwr.s
# Source file rndnum2.c is used instead of rndnum.s

# To compile datagen, run
#	make -f nonintel.mak

# To uninstall datagen, run
#	deinst

OBJ=rndinit.o \
	rnd.o \
	rndpwr.o \
	rndnum.o \
	rndfrac.o \
	getmd5.o \
	md5c.o \
	greg2jd.o \
	jd2greg.o \
	astrint.o \
	datagen.tab.o \
	lex.yy.o

CC=gcc

CFLAGS=-c -Wall -O6

all:		libdg.a datagen

datagen:	$(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o datagen -ll -lfl -lm

libdg.a:	$(OBJ)
	rm -f libdg.a
	ar r libdg.a $(OBJ)

datagen.tab.o:		datagen.tab.c
	$(CC) $(CFLAGS) datagen.tab.c

lex.yy.o:	lex.yy.c
	$(CC) $(CFLAGS) lex.yy.c

datagen.tab.c:		datagen.y
	bison -d datagen.y
	# change YYDEBUG to 1 to debug datagen.y

lex.yy.c:	datagen.l
	flex datagen.l
	# use the -d option to turn on flex debugging
	# flex -d datagen.l

greg2jd.o:	greg2jd.c
	$(CC) $(CFLAGS) greg2jd.c

jd2greg.o:	jd2greg.c
	$(CC) $(CFLAGS) jd2greg.c

astrint.o:	astrint.c
	$(CC) $(CFLAGS) astrint.c

rnd.o:		rnd2.c
	$(CC) $(CFLAGS) rnd2.c -o rnd.o

rndpwr.o:	rndpwr2.c
	$(CC) $(CFLAGS) rndpwr2.c -o rndpwr.o

rndnum.o:	rndnum2.c
	$(CC) $(CFLAGS) rndnum2.c -o rndnum.o

rndfrac.o:	rndfrac2.c
	$(CC) $(CFLAGS) rndfrac2.c -o rndfrac.o

rndinit.o:	rndinit.c
	$(CC) $(CFLAGS) rndinit.c

getmd5.o:	getmd5.c
	$(CC) $(CFLAGS) getmd5.c

md5c.o:		md5c.c
	$(CC) $(CFLAGS) md5c.c

clean:	
	rm -f datagen lex.yy.c datagen.tab*
	rm -f dgtst*.data dgtst*.msg
	rm -f libdg.a
	rm -f $(OBJ)
