# rnd.s - random number generator based on 16 byte seed
# Version 1.7.0
# Copyright (C) 1999-2010   dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

# Usage:
#   	int rnd(unsigned char *sd);

# Returns:
#       high order bit of seed

# Called by:
#	unsigned int rndpwr(int bits, unsigned char *sd);

# initialize the seed with:
#   	unsigned char *sd;
#   	sd = (unsigned char *) rndinit();

# history:
# Version 0.2.1 
#       Remove push and pop of %eax
#       Make rnd() a function of integer
# Version 0.2.0 
#	Change stack manipulation
#	Save and restore %eax due to register variable yyn
#		in bison
# Version 1.3.0 
#	Eliminated one step copying to sd3
# Version 1.7.0 
#	Change rnd() to return high order bit

	.file	"rnd.s"
	.version	"1.7.0"
gcc2_compiled.:
.text
	.align 4
.globl rnd
	.type	 rnd,@function
rnd:
	pushl %ebp
	movl %esp,%ebp
	subl $64,%esp
	/*************** pushl %eax *****************/
	pushl %esi
	movl 8(%ebp),%esi		/* retrieve the seed pointer parm */
	movl %esi,-4(%ebp)		/* save sd pointer */

	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	shll $1,%eax			/* double it */
	movl %eax,-48(%ebp)		/* save in sd2 */
	movl 4(%esi),%eax		/* get sd+4 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-44(%ebp)		/* save in sd2+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-40(%ebp)		/* save in sd2+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-36(%ebp)		/* save in sd2+12 */

	clc				/* clear carry flag */
	movl 8(%esi),%eax		/* get sd+8 */
	addl (%esi),%eax		/* add sd */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl 4(%esi),%eax		/* add sd+4 */
	movl %eax,12(%esi)		/* save in sd+12 */

	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	addl -48(%ebp),%eax		/* add sd2 */
	movl %eax,(%esi)		/* save in sd */
	movl 4(%esi),%eax		/* get sd+4 */
	adcl -44(%ebp),%eax		/* add sd2+4 */
	movl %eax,4(%esi)		/* save in sd+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	adcl -40(%ebp),%eax		/* add sd2+8 */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl -36(%ebp),%eax		/* add sd2+12 */
	movl %eax,12(%esi)		/* save in sd+12 */
	shrl $31,%eax                   /* get high order bit  of seed */

	jmp .L1
	.align 4
.L1:
	popl %esi
	movl %ebp,%esp
	popl %ebp
	ret
.Lfe1:
	.size	 rnd,.Lfe1-rnd
	.ident	"GCC: (GNU) 2.7.2"
