/* dgpois.c Version 1.7.0. Generate poisson */
/* Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The population mean is in dg->mu. */
/* Prints the number of successes. */

void dgpois(dgfmt *dg)
   {
   int i;
   int tot;
   int pfxlen;
   double prob;
   char str[16];
   if (dg->mu < 0.1 || dg->mu > 30.0)
      {
      fprintf(stderr,"\ndgpois: invalid "
         "population mean: %f\n",
         dg->mu);
      fprintf(stderr,"Population mean "
         "is 0.1 - 30.0\n");
      exit(1);
      } /* invalid mu */
   tot = 0;
   prob = dg->mu / 100.0;
   i = 100;
   while (i--)
      {
      if (rndfrac(dg->sd) < prob)
	 tot++;
      } /* for each trial */
   sprintf(str,"%d",tot);
   pfxlen = dg->fromlen - strlen(str);
   if (pfxlen > 0)
      {
      while (pfxlen--)
         putstr(dg->opthndl,"0");
      } /* if leading zeros */
   putstr(dg->opthndl,str);
   } /* dgpois */
