/* dginit.c Version 1.7.0. initialize the dgfmt structure */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

dgfmt *dginit(void)
   {
   dgfmt *dg;
   dg = (dgfmt *) malloc(sizeof(dgfmt));
   if (dg == NULL)
      {
      fprintf(stderr,"dginit: out of memory "
         "alocating the dg structure\n");
      exit(1);
      } /* out of memory */

   dg->strptr   = (char *) NULL;
   dg->padstr   = (char *) NULL;
   dg->slcthead = (slctfmt *) NULL;
   dg->slcttail = (slctfmt *) NULL;
   dg->loflrng  = dg->hiflrng = dg->sinestep =
      dg->sinex = dg->prob = dg->mu =
      dg->lointrng = dg->hiintrng = 0.0;
   dg->fromlen  = dg->tolen = dg->totlen =
      dg->verbose = dg->wtfact = dg->rcdnum  =
      dg->lentype = dg->padding = dg->dec =
      dg->sign = dg->slctmax = 0;
   dg->opthndl = 1;          /* default = stdout */
   dg->str = (char *) malloc(65536);
   if (dg->str == NULL)
      {
      fprintf(stderr,"dginit: out of memory "
         "alocating dg->str\n");
      exit(1);
      } /* out of memory */
   dg->sd = (unsigned char *) rndinit();
   if (dg->sd == NULL)
      {
      fprintf(stderr,"dginit: out of memory "
         "alocating dg->sd\n");
      exit(1);
      } /* out of memory */
   dg->slcthead = (slctfmt *) slctinit(dg);
   if (dg->slcthead == NULL)
      {
      fprintf(stderr,"dginit: out of memory "
         "alocating dg->slcthead\n");
      exit(1);
      } /* out of memory */
   dg->slcttail = (slctfmt *) slctinit(dg);
   if (dg->slcttail == NULL)
      {
      fprintf(stderr,"dginit: out of memory "
         "alocating dg->slcttail\n");
      exit(1);
      } /* out of memory */
   dg->slcthead->next = (slctfmt *) dg->slcttail;
   dg->slcttail->next = (slctfmt *) dg->slcttail;
   return(dg);
   }  /* dginit */
