/* dgdtrng.c Version 1.7.0. Generate date within range */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The from/to julian day is the scientific */
/* julian day used in astonomy. */
/* It is based on the current time down to the */
/* second at the time of calculation. */
/* Therefore, two calls to this subroutine */
/* will yield different fractions, depending */
/* when the calls are made. */

/* To find out the julian day, call greg2jd() as */
/* it is called in dgjul.c. */

/* The input parameters are from and to julian day */
/* The output parameter is the structure tm */

void dgdtrng(dgfmt *dg,
   double fromjd, double tojd,
   struct tm *t)
   {
   int year,month,day;
   int hour,minute;
   int wday;
   double sec;
   double diff;
   double jd;
   double jddec31;
   if (tojd < fromjd)
      {
      fprintf(stderr,"dgdtrng: from date: %f "
         "to date: %f\n",
         fromjd, tojd);
      fprintf(stderr,"From date later than to date\n");
      exit(1);
      } /* invalid from/to jd */
   diff = tojd - fromjd;
   jd = fromjd + (rndfrac(dg->sd) * diff);
   jd2greg(jd,&year,&month,&day,
      &hour,&minute,&sec);
   t->tm_year = year;
   t->tm_mon  = month - 1;
   t->tm_mday = day;
   t->tm_hour = hour;
   t->tm_min  = minute;
   t->tm_sec  = (int) astrint(sec);
   jddec31 = greg2jd(year-1,12,31,0.0);
   t->tm_yday = (int) astrint(jd - jddec31);
   wday = ((int) astrint(jd) % 7) - 1;
   if (hour >= 12) wday--;
   if (wday < 0) wday += 7;
   t->tm_wday  = wday;
   t->tm_isdst = 0;
   } /* dgdtrng */
