/*
jd2greg.c Release 1.7.0  Julian Day to Gregorian Subroutine
Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <time.h>
#include <math.h>

/* This program is based on Peter Duffett-Smith */
/* Practical Astronomy with Your Calculator */
/* Third Edition */
/* Cambridge University Press */
/* ISBN 0 521 35629 6 hardback */
/* ISBN 0 521 35699 7 paperback */
/* Chapter 5: Converting the Julian Day Number */
/* to the Calendar Date */

/* In this implementation, */
/* dates prior to the Christian Era are true */
/* Julian dates.  Year 0 is bypassed. */
/* The year has been adjusted, if less than 1, */
/* to allow for true dates. */
/* December 31, -1 is immediately followed by */
/* January 1, 1. */
/* October 4, 1582 is immediately followed by */
/* October 15, 1582. */

/* Notice that the integer routine described */
/* in the book has been implemented as astrint() */
/* astrint(-3.914) = -3.0 */
/* astrint() gives the same result as the integer */
/* result from the modf() function. */

void jd2greg(jd,year,month,day,hour,minute,second)
double jd;
int *year,*month,*day,*hour,*minute;
double *second;
   {
   int flda,fldb,fldc,fldd,flde,fldg;
   double tmpjd,jdint,jdfrac,dblday;
   double dblg,dblhour,dblminute;
   double astrint();
   tmpjd = jd + 0.5;
   if (0) jdint = astrint(tmpjd);
   if (0) jdfrac  = tmpjd - jdint;
   jdfrac = modf(tmpjd,&jdint);
   if (jdint > 2299160.0)
      {
      flda = (int) astrint((jdint - 1867216.25)
         / 36524.25);
      fldb = (int) jdint + 1 + flda - (flda / 4);
      } /* if Gregorian era */
   else fldb = (int) jdint;
   fldc = fldb + 1524;
   fldd = (int) astrint((fldc - 122.1)
      / 365.25);
   flde = (int) astrint(365.25 * fldd);
   dblg = ((fldc - flde) / 30.6001);
   fldg = (int) astrint(dblg);
   dblday = fldc - flde + jdfrac
      - astrint(30.6001 * fldg);
   *day = (int) astrint(dblday);
   dblhour = (double) (dblday - *day) * 24.0;
   *hour = (int) astrint(dblhour);
   dblminute = (double) (dblhour - *hour) * 60.0;
   *minute = (int) astrint(dblminute);
   *second = (double) (dblminute - *minute) * 60.0;
   if (fldg <= 13)
      {
      *month = fldg - 1;
      } /* calc month */
   else
      {
      *month = fldg - 13;
      } /* calc month */
   if (*month > 2) *year = fldd - 4716;
   else *year = fldd - 4715;
   if (*year < 1)
      {
      printf("adj year %d ", *year);
      *year = *year - 1;
      printf("to %d\n", *year);
      } /* if bc */
   } /* jd2greg */
