#!/usr/bin/make

# xpat.mak Version 1.4.0 - Compile xpat.c
# Copyright (C) 2001-2005  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Commands when running xpat:
# r = reset
# q = quit

OBJ=xpat.o \
	rnd.o \
	rndnum.o \
	rndpwr.o \
	rndfrac.o \
	rndinit.o \
	getmd5.o \
	md5c.o

CC=gcc

CFLAGS=-I/usr/X11R6/include/X11 -I. -c -Wall -O6

CFLG=-c -Wall -O6

LDFLAGS=-L/usr/X11R6/lib -lX11 -lm

all:		$(OBJ) xpat

xpat:		xpat.o $(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o xpat $(LDFLAGS)

xpat.o:		xpat.c
	$(CC) $(CFLAGS) xpat.c

rnd.o:		rnd.s
	$(CC) $(CFLG) rnd.s

rndnum.o:	rndnum.s
	$(CC) $(CFLG) rndnum.s

rndpwr.o:	rndpwr.s
	$(CC) $(CFLG) rndpwr.s

rndfrac.o:	rndfrac.s
	$(CC) $(CFLG) rndfrac.s

rndinit.o:	rndinit.c
	$(CC) $(CFLG) rndinit.c

getmd5.o:	getmd5.c
	$(CC) $(CFLG) getmd5.c

md5c.o:		md5c.c
	$(CC) $(CFLG) md5c.c

clean:
	rm -f $(OBJ) xpat
