/*
twochi.c Version 1.4.0 - Chi Square Test
Datagen versus ran2
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This chi square test is based on */
/* Robert Sedgwick */
/* Algorithms in C */
/* Chapter 35, Random Numbers */

/* The ran2 random number generator is taken from */
/* Numerical Recipes in C */
/* Chapter 7.1 */

/* twochi compares the random number generator */
/* in datagen to the generator called ran2  */
/* for the chi-square distribution. */
/* A mean and variance is created with each */
/* generator, and the difference is compared */
/* to zero. */

/* ran2 corresponds to rndfrac in datagen. */
/* It generates a random fraction between 0 and 1. */

/* sample test: */

/* twochi 10000 17 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size categories\n",
      pgm);
   fprintf(stderr,"Where size is 30 to 100000\n");
   fprintf(stderr,"Where categories is 2 to 30\n");
   fprintf(stderr,"Size is more than 10 times larger "
      "than categories\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,size,cats;
   int idum;
   char f_rslt[64];
   char critmsg[64];
   double dblsz;
   double dblcats;
   double sumchione;
   double sumchitwo;
   double *p,*q;
   double *rone;
   double *rtwo;
   double psucc;
   double qfail;
   double popmean;
   double popvar;
   double popstdev;
   double sumxone;
   double sumxonesqd;
   double varone;
   double stdevone;
   double sumxtwo;
   double sumxtwosqd;
   double vartwo;
   double stdevtwo;
   double chisqvarone;
   double chisqvartwo;
   double rsltone;
   double rslttwo;
   double negtblv,postblv;
   double fstat;
   double fval;
   double ran2(int *idum);
   double getftbl(int degf);
   if (argc != 3) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 30 || size > 100000)
      {
      fprintf(stderr,"Invalid size.\n");
      putstx(*argv);
      } /* bad size */
   dblsz = (double) size;
   cats = atoi(*(argv+2));
   if (cats < 2)
      {
      fprintf(stderr,"Categories is too small.\n");
      putstx(*argv);
      } /* not enough cats */
   if (cats > 30)
      {
      fprintf(stderr,"Categories is too large.\n");
      putstx(*argv);
      } /* if cats too large */
   dblcats = (double) cats;
   if (size < cats * 10)
      {
      fprintf(stderr,"Size is too small.\n");
      putstx(*argv);
      } /* if size too small */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"twochi: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   rone = (double *) malloc(cats * sizeof(double) + 32);
   if (rone == NULL)
      {
      fprintf(stderr,"twochi: out of memory "
	 "allocating datagen cats.\n");
      exit(1);
      } /* out of memory */
   rtwo = (double *) malloc(cats * sizeof(double) + 32);
   if (rtwo == NULL)
      {
      fprintf(stderr,"twochi: out of memory "
	 "allocating ran2 cats.\n");
      exit(1);
      } /* out of memory */
   /* Initialize ran2 shuffle table. */
   /* ran2 has 2 billion initial seeds. */
   idum = (int) - rndpwr(31,sd);
   psucc    = 1.0 / dblcats;
   qfail    = 1.0 - psucc;
   popmean  = dblsz * psucc;
   popvar   = dblsz * psucc * qfail;
   popstdev = sqrt(popvar);
   p = rone;
   q = p + cats;
   while (p < q) *p++ = 0.0;
   p = rtwo;
   q = p + cats;
   while (p < q) *p++ = 0.0;
   i = 0;
   while (i++ < size)
      {
      p = rone + rndnum(cats,sd);
      *p += 1.0;
      p = rtwo + (int) floor(ran2(&idum) * dblcats);
      *p += 1.0;
      } /* generate histogram */
   i = 0;
   sumxone = sumxonesqd = sumchione = 0.0;
   p = rone;
   while (i++ < cats)
      {
      sumchione  += ((*p) * (*p));
      sumxone    += *p;
      sumxonesqd += ((*p) * (*p));
      p++;
      } /* calc chi sq */
   rsltone = ((dblcats * sumchione) / dblsz) - dblsz;
   varone = (sumxonesqd - (sumxone * sumxone / dblcats))
      / (dblcats - 1.0);
   stdevone = sqrt(varone);
   chisqvarone = (dblcats - 1.0) * varone / popvar;
   i = 0;
   sumxtwo = sumxtwosqd = sumchitwo = 0.0;
   p = rtwo;
   while (i++ < cats)
      {
      sumchitwo  += ((*p) * (*p));
      sumxtwo    += *p;
      sumxtwosqd += ((*p) * (*p));
      p++;
      } /* calc chi sq */
   rslttwo = ((dblcats * sumchitwo) / dblsz) - dblsz;
   vartwo = (sumxtwosqd - (sumxtwo * sumxtwo / dblcats))
      / (dblcats - 1.0);
   stdevtwo = sqrt(vartwo);
   chisqvartwo = (dblcats - 1.0) * vartwo / popvar;
   printf("               Stdev "
      "       Chi-square     Chi-square\n");
   printf("Population %12.6f\n", popstdev);
   printf("Datagen    %12.6f %14.6f %14.6f\n",
      stdevone, chisqvarone, rsltone);
   printf("Ran2       %12.6f %14.6f %14.6f\n",
      stdevtwo, chisqvartwo, rslttwo);
   chirange(cats-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   printf("The first  chi-square column "
      "is based on variance.\n");
   printf("The second chi-square column "
      "is based on goodness of fit.\n");
   printf("\n");
   if (varone > vartwo)
      {
      if (vartwo != 0.0)
         fstat = varone / vartwo;
      else
	 fstat = 1.0;
      } /* if var1 > var2 */
   else
      {
      if (varone != 0.0)
         fstat = vartwo / varone;
      else
	 fstat = 1.0;
      } /* if var2 > var1 */
   fval = getftbl(cats-1);
   if (fstat > fval)
      strcpy(f_rslt,"Test Failed");
   else
      strcpy(f_rslt,"Test Passed");
   strcpy(critmsg,"Critical Value    2 tail test, 95%");
   printf("     f Statistic   %s\n",
      critmsg);
   printf("%15.6f %15.6f      %s\n",
      fstat, fval, f_rslt);
   return(0);
   } /* main */
