/*
smplsz.c Version 1.4.0 - Sample program sample size
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 8, The Normal Probability Distribution */
/* Section 4, Sampling Distribution of the Mean */
/* Chapter 9, Statistical Estimation */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* smplsz 95.0 0.112 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s confidence "
      "est_error x_length\n", pgm);
   fprintf(stderr,"Where confidence is "
      "90.0, 95.0, 98.0, 99.0\n");
   fprintf(stderr,"      est_error is 0.001 to 70\n");
   fprintf(stderr,"      x_length is 2 to 30\n");
   fprintf(stderr,"Example: %s "
      "95.0 0.01 12\n", pgm);
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int size;
   int xlength;
   int ofst;
   int smplsize;
   double confidence;
   double esterr;
   double dblpbase;
   double *p,*q;
   double *prob;
   double mu,musq;
   double est_xsq;
   double variance,stdev;
   int getsz(double confidence, double esterr,
      double variance);
   if (argc != 4) putstx(*argv);
   confidence = atof(*(argv+1));
   if (confidence == 90.0 || confidence == 95.0
      ||confidence == 98.0 || confidence == 99.0);
   else
      {
      fprintf(stderr,"Invalid confidence.\n");
      putstx(*argv);
      } /* bad confidence */
   esterr = atof(*(argv+2));
   if (esterr < 0.001 || esterr > 70.0)
      {
      fprintf(stderr,"Invalid error of estimation.\n");
      putstx(*argv);
      } /* bad error of estimation */
   xlength = (int) atoi(*(argv+3));
   if (xlength < 2)
      {
      fprintf(stderr,"x_length "
	 "is too small.\n");
      putstx(*argv);
      } /* xlength too small */
   if (xlength > 30)
      {
      fprintf(stderr,"x_length "
	 "is too large.\n");
      putstx(*argv);
      } /* xlength too large */
   dblpbase = (double) xlength * (double) xlength;
   smplsize = (int) dblpbase;
   prob = (double *) malloc((smplsize + 1) * sizeof(double) + 32);
   if (prob == NULL)
      {
      fprintf(stderr,"smplsz: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   p = (double *) prob;
   q = (double *) p + smplsize + 1;
   while (p < q) *p++ = 0.0;
   i = 2;
   while (i <= (xlength + xlength))
      {
      j = 2;
      while (j <= (xlength + xlength))
	 {
	 ofst = (i + j) >> 1;
	 p = (double *) prob + ofst;
	 *p += 1.0;
	 j += 2;
	 } /* for each second value of X */
      i += 2;
      } /* for each first value of X */
   p = (double *) prob + 2;
   q = (double *) p + smplsize;
   while (p < q)
      {
      if (*p < 1.0) break;
      *p++ /= dblpbase;
      } /* for each # of heads */
   mu = 0.0;
   p = (double *) prob + 2;
   q = (double *) p + smplsize + 1;
   i = 2;
   while (p < q)
      {
      if (*p == 0.0) break;
      mu += ((double) i * *p++);
      i++;
      } /* for each # of observations */
   musq = mu * mu;
   est_xsq = 0.0;
   p = (double *) prob + 2;
   q = (double *) p + smplsize + 1;
   i = 2;
   while (p < q)
      {
      if (*p == 0.0) break;
      est_xsq += ((double) (i * i) * *p++);
      i++;
      } /* for each # of observations */
   variance = est_xsq -  musq;
   stdev    = sqrt(variance);
   size = getsz(confidence, esterr, variance);
   printf("Sample size is %d\n", size);
   return(0);
   } /* main */
