/*
slots.c  Version 1.4.0  Simulate Powerball Drawing
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* John Scarne */
/* Scarne's New Complete Guide to Gambling */
/* Fully revised, expanded, updated edition */
/* New York: Simon & Schuster, 1961, 1974, 1986 */
/* A Fireside book, 871 p. */
/* ISBN: 0-671-21734-8 hardback */
/* ISBN: 0-671-63063-6 paperback */
/* Chapter 15, Slot Machines: One-armed Bandits */
/* Section: Slot Machine Odds */

/* If the chi-square test fails, repeat your test. */
/* The chi-square usually passes in the next test. */
/* If the chi-square fails consistently, then the */
/* program has to be reviewed for correctness. */

/* The higher the number of iterations, the more */
/* likely the chi-square test will pass.  The chi-square */
/* test needs to have its categories filled with at */
/* least a 10 count in order to pass consistently. */
/* With 100000 iterations, the chi-square test passes */
/* consistently. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

#define CHE 1
#define ORA 2
#define BAR 3
#define PLM 4
#define BEL 5
#define MEL 6
#define SEV 7
#define LEM 8
#define SEVORA  9
#define PLMBAR 10
#define BELBAR 11
#define MELORA 12
#define SEVBAR 13
#define BASE 8000

typedef struct statfmt {
   int wins;
   int coins;
   double prob;
   } statfmt;

typedef struct playfmt {
   int one;
   int two;
   int tre;
   } playfmt;

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s coins value\n", pgm);
   fprintf(stderr,"Where coins is 30 - 1000000000\n");
   fprintf(stderr,"      value is 0.01 - 1000.0\n");
   fprintf(stderr,"Example: %s 10000 0.10\n", pgm);
   exit(1);
   } /* putstx */

void bldcolone(unsigned char *col)
   {
   unsigned char *p;
   p = (unsigned char *) col;
   *p++ = ORA;
   *p++ = MEL;
   *p++ = PLM;
   *p++ = CHE;
   *p++ = PLM;
   *p++ = ORA;
   *p++ = SEV;
   *p++ = BELBAR;
   *p++ = ORA;
   *p++ = CHE;
   *p++ = BAR;
   *p++ = PLM;
   *p++ = ORA;
   *p++ = PLM;
   *p++ = MEL;
   *p++ = PLM;
   *p++ = ORA;
   *p++ = PLM;
   *p++ = BAR;
   *p++ = PLM;
   } /* bldcolone */

void bldcoltwo(unsigned char *col)
   {
   unsigned char *p;
   p = (unsigned char *) col;
   *p++ = CHE;
   *p++ = PLM;
   *p++ = CHE;
   *p++ = SEVORA;
   *p++ = CHE;
   *p++ = BEL;
   *p++ = PLMBAR;
   *p++ = BEL;
   *p++ = CHE;
   *p++ = ORA;
   *p++ = BEL;
   *p++ = MELORA;
   *p++ = PLM;
   *p++ = BEL;
   *p++ = CHE;
   *p++ = BAR;
   *p++ = ORA;
   *p++ = CHE;
   *p++ = BEL;
   *p++ = MELORA;
   } /* bldcoltwo */

void bldcolthree(unsigned char *col)
   {
   unsigned char *p;
   p = (unsigned char *) col;
   *p++ = BEL;
   *p++ = ORA;
   *p++ = PLM;
   *p++ = BEL;
   *p++ = ORA;
   *p++ = LEM;
   *p++ = BEL;
   *p++ = MELORA;
   *p++ = BEL;
   *p++ = PLM;
   *p++ = LEM;
   *p++ = BEL;
   *p++ = PLM;
   *p++ = BEL;
   *p++ = SEVBAR;
   *p++ = LEM;
   *p++ = BEL;
   *p++ = MELORA;
   *p++ = BEL;
   *p++ = LEM;
   } /* bldcolthree */

int main(argc,argv)
int argc;
char **argv;
   {
   int indx;
   int totplay;
   int maxplay;
   int totwins;
   unsigned char colone[32];
   unsigned char coltwo[32];
   unsigned char colthree[32];
   double coinval;
   double dblsz;
   double rootsz;
   playfmt play;
   statfmt chenilnil;
   statfmt chechenil;
   statfmt oraorabar;
   statfmt oraoraora;
   statfmt plmplmbar;
   statfmt plmplmplm;
   statfmt belbelbar;
   statfmt belbelbel;
   statfmt melmelbar;
   statfmt melmelmel;
   statfmt barbarbar;
   statfmt sevsevsev;
   statfmt other;
   double dblwin;
   double dblearn;
   double totearn;
   double prob;
   double winning;
   double sumchi;
   double totprob;
   double expect;
   double diff;
   double mean;
   double variance;
   double stdev;
   double popmean;
   double popvar;
   double popstdev;
   double std_err;
   double sumx;
   double estx;
   double sumxsqd;
   double estxsqd;
   double zscore;
   double lorange;
   double hirange;
   double chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 3) putstx(*argv);
   maxplay = atoi(*(argv+1));
   if (maxplay < 30 || maxplay > 1000000000)
      {
      fprintf(stderr,"Invalid coins\n");
      putstx(*argv);
      } /* if maxplay invalid */
   dblsz = (double) maxplay;
   rootsz = sqrt(dblsz);
   coinval = (double) atof(*(argv+2));
   if (coinval < 0.01 || coinval > 1000.0)
      {
      fprintf(stderr,"Invalid value\n");
      putstx(*argv);
      } /* if coinval invalid */
   sd = (unsigned char *) rndinit();
   bldcolone(colone);
   bldcoltwo(coltwo);
   bldcolthree(colthree);
   chenilnil.wins = chechenil.wins
      = oraorabar.wins = oraoraora.wins
      = plmplmbar.wins = plmplmplm.wins
      = belbelbar.wins = belbelbel.wins
      = melmelbar.wins = melmelmel.wins
      = barbarbar.wins = sevsevsev.wins
      = other.wins     = 0;
   chenilnil.coins =   2;
   chechenil.coins =   5;
   oraorabar.coins =  10;
   oraoraora.coins =  10;
   plmplmbar.coins =  14;
   plmplmplm.coins =  14;
   belbelbar.coins =  18;
   belbelbel.coins =  18;
   melmelbar.coins = 100;
   melmelmel.coins = 100;
   barbarbar.coins = 100;
   sevsevsev.coins = 200;
   other.coins     =   0;
   /* the probability denominator is 20^3 */
   chenilnil.prob = (2.0 * 14.0 * 20.0) / BASE;
   chechenil.prob = (2.0 *  6.0 * 20.0) / BASE;
   oraorabar.prob = (5.0 *  5.0 *  1.0) / BASE;
   oraoraora.prob = (5.0 *  5.0 *  4.0) / BASE;
   plmplmbar.prob = (7.0 *  3.0 *  1.0) / BASE;
   plmplmplm.prob = (7.0 *  3.0 *  3.0) / BASE;
   belbelbar.prob = (1.0 *  5.0 *  1.0) / BASE;
   belbelbel.prob = (1.0 *  5.0 *  8.0) / BASE;
   melmelbar.prob = (2.0 *  2.0 *  1.0) / BASE;
   melmelmel.prob = (2.0 *  2.0 *  2.0) / BASE;
   barbarbar.prob = (3.0 *  2.0 *  1.0) / BASE;
   sevsevsev.prob = (1.0 *  1.0 *  1.0) / BASE;

   totprob = chenilnil.prob
      + chechenil.prob
      + oraorabar.prob
      + oraoraora.prob
      + plmplmbar.prob
      + plmplmplm.prob
      + belbelbar.prob
      + belbelbel.prob
      + melmelbar.prob
      + melmelmel.prob
      + barbarbar.prob
      + sevsevsev.prob;

   other.prob     = 1.0 - totprob;

   estx = estxsqd = 0.0;
   expect   = chenilnil.prob * dblsz;
   estx    += expect * chenilnil.prob;
   estxsqd += expect * expect * chenilnil.prob;

   expect   = chechenil.prob * dblsz;
   estx    += expect * chechenil.prob;
   estxsqd += expect * expect * chechenil.prob;

   expect   = oraorabar.prob * dblsz;
   estx    += expect * oraorabar.prob;
   estxsqd += expect * expect * oraorabar.prob;

   expect   = oraoraora.prob * dblsz;
   estx    += expect * oraoraora.prob;
   estxsqd += expect * expect * oraoraora.prob;

   expect   = plmplmbar.prob * dblsz;
   estx    += expect * plmplmbar.prob;
   estxsqd += expect * expect * plmplmbar.prob;

   expect   = plmplmplm.prob * dblsz;
   estx    += expect * plmplmplm.prob;
   estxsqd += expect * expect * plmplmplm.prob;

   expect   = belbelbar.prob * dblsz;
   estx    += expect * belbelbar.prob;
   estxsqd += expect * expect * belbelbar.prob;

   expect   = belbelbel.prob * dblsz;
   estx    += expect * belbelbel.prob;
   estxsqd += expect * expect * belbelbel.prob;

   expect   = melmelbar.prob * dblsz;
   estx    += expect * melmelbar.prob;
   estxsqd += expect * expect * melmelbar.prob;

   expect   = melmelmel.prob * dblsz;
   estx    += expect * melmelmel.prob;
   estxsqd += expect * expect * melmelmel.prob;

   expect   = barbarbar.prob * dblsz;
   estx    += expect * barbarbar.prob;
   estxsqd += expect * expect * barbarbar.prob;

   expect   = sevsevsev.prob * dblsz;
   estx    += expect * sevsevsev.prob;
   estxsqd += expect * expect * sevsevsev.prob;

   expect   = other.prob * dblsz;
   estx    += expect * other.prob;
   estxsqd += expect * expect * other.prob;

   popmean  = estx;
   popvar   = estxsqd - (estx * estx);
   popstdev = sqrt(popvar);
   std_err  = popstdev / rootsz;

   totplay = maxplay;
   while (totplay--)
      {
      indx = (int) rndnum(20,sd);
      play.one = (unsigned char) colone[indx];
      indx = (int) rndnum(20,sd);
      play.two = (unsigned char) coltwo[indx];
      indx = (int) rndnum(20,sd);
      play.tre = (unsigned char) colthree[indx];
      if (play.one == CHE
	 && play.two != CHE)
	 chenilnil.wins++;
      else if (play.one == CHE
	 && play.two == CHE)
	 chechenil.wins++;
      else if (play.one == ORA
	 && play.two == ORA
	 && play.tre == SEVBAR)
	 oraorabar.wins++;
      else if (play.one == ORA    
	 && play.two == SEVORA 
	 && play.tre == SEVBAR)
	 oraorabar.wins++;
      else if (play.one == ORA    
	 && play.two == MELORA 
	 && play.tre == SEVBAR)
	 oraorabar.wins++;
      else if (play.one == ORA    
	 && play.two == ORA    
	 && play.tre == ORA)
	 oraoraora.wins++;
      else if (play.one == ORA    
	 && play.two == SEVORA 
	 && play.tre == ORA)
	 oraoraora.wins++;
      else if (play.one == ORA    
	 && play.two == MELORA 
	 && play.tre == ORA)
	 oraoraora.wins++;
      else if (play.one == ORA    
	 && play.two == ORA    
	 && play.tre == MELORA)
	 oraoraora.wins++;
      else if (play.one == ORA    
	 && play.two == SEVORA 
	 && play.tre == MELORA)
	 oraoraora.wins++;
      else if (play.one == ORA    
	 && play.two == MELORA 
	 && play.tre == MELORA)
	 oraoraora.wins++;
      else if (play.one == PLM    
	 && play.two == PLM    
	 && play.tre == SEVBAR)
	 plmplmbar.wins++;
      else if (play.one == PLM    
	 && play.two == PLMBAR 
	 && play.tre == SEVBAR)
	 plmplmbar.wins++;
      else if (play.one == PLM    
	 && play.two == PLM    
	 && play.tre == PLM)
	 plmplmplm.wins++;
      else if (play.one == PLM    
	 && play.two == PLMBAR
	 && play.tre == PLM)
	 plmplmplm.wins++;
      else if (play.one == BELBAR 
	 && play.two == BEL    
	 && play.tre == SEVBAR)
	 belbelbar.wins++;
      else if (play.one == BELBAR 
	 && play.two == BEL    
	 && play.tre == BEL)
	 belbelbel.wins++;
      else if (play.one == MEL    
	 && play.two == MELORA 
	 && play.tre == SEVBAR)
	 melmelbar.wins++;
      else if (play.one == MEL    
	 && play.two == MELORA 
	 && play.tre == MELORA)
	 melmelmel.wins++;
      else if (play.one == BAR    
	 && play.two == BAR    
	 && play.tre == SEVBAR)
	 barbarbar.wins++;
      else if (play.one == BAR    
	 && play.two == PLMBAR 
	 && play.tre == SEVBAR)
	 barbarbar.wins++;
      else if (play.one == BELBAR    
	 && play.two == BAR    
	 && play.tre == SEVBAR)
	 barbarbar.wins++;
      else if (play.one == BELBAR    
	 && play.two == PLMBAR 
	 && play.tre == SEVBAR)
	 barbarbar.wins++;
      else if (play.one == SEV    
	 && play.two == SEVORA 
	 && play.tre == SEVBAR)
	 sevsevsev.wins++;
      else other.wins++;
      } /* tst loop maxplay times */

   totwins = 0;
   winning = totearn = totprob = sumx
      = sumxsqd = sumchi = 0.0;
   printf("Combination      Wins   Earnings "
      "   Portion    Probab.    Z Score\n");
   totwins += chenilnil.wins;
   dblwin  = (double) chenilnil.wins;
   dblearn = dblwin
      * (double) chenilnil.coins
      * coinval;
   totearn += dblearn;
   expect  = chenilnil.prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   winning  += dblearn;
   totprob  += chenilnil.prob;
   sumx     += dblwin * chenilnil.prob;
   sumxsqd  += dblwin * dblwin * chenilnil.prob;
   sumchi   += diff * diff / expect;
   printf("Che --- --- %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      chenilnil.wins,
      dblearn,
      dblwin / dblsz, 
      chenilnil.prob,
      zscore);

   dblwin  = (double) chechenil.wins;
   totwins += chechenil.wins;
   dblearn = dblwin
      * (double) chechenil.coins
      * coinval;
   totearn += dblearn;
   expect  = chechenil.prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   winning += dblearn;
   totprob  += chechenil.prob;
   sumx     += dblwin * chechenil.prob;
   sumxsqd  += dblwin * dblwin * chechenil.prob;
   sumchi   += diff * diff / expect;
   printf("Che Che --- %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      chechenil.wins,
      dblearn,
      dblwin / dblsz, 
      chechenil.prob,  zscore);

   dblwin  = (double) (oraorabar.wins + oraoraora.wins);
   totwins += (oraorabar.wins + oraoraora.wins);
   dblearn = dblwin
      * (double) oraoraora.coins
      * coinval;
   totearn += dblearn;
   winning += dblearn;
   prob      = oraorabar.prob + oraoraora.prob;
   totprob  += prob;
   expect  = prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   sumx     += dblwin * prob;
   sumxsqd  += dblwin * dblwin * prob;
   sumchi   += diff * diff / expect;
   printf("Ora Ora Ora %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      oraorabar.wins + oraoraora.wins,
      dblearn,
      dblwin / dblsz, 
      prob,
      zscore);

   dblwin  = (double) (plmplmbar.wins + plmplmplm.wins);
   totwins += (plmplmbar.wins + plmplmplm.wins);
   dblearn = dblwin
      * (double) plmplmplm.coins
      * coinval;
   totearn += dblearn;
   winning += dblearn;
   prob      = plmplmbar.prob + plmplmplm.prob;
   totprob  += prob;
   expect  = prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   sumx     += dblwin * prob;
   sumxsqd  += dblwin * dblwin * prob;
   sumchi   += diff * diff / expect;
   printf("Plm Plm Plm %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      plmplmbar.wins + plmplmplm.wins,
      dblearn,
      dblwin / dblsz, 
      prob,
      zscore);

   dblwin  = (double) (belbelbar.wins + belbelbel.wins);
   totwins += (belbelbar.wins + belbelbel.wins);
   dblearn = dblwin
      * (double) belbelbel.coins
      * coinval;
   totearn += dblearn;
   winning += dblearn;
   prob      = belbelbar.prob + belbelbel.prob;
   totprob  += prob;
   expect  = prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   sumx     += dblwin * prob;
   sumxsqd  += dblwin * dblwin * prob;
   sumchi   += diff * diff / expect;
   printf("Bel Bel Bel %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      belbelbar.wins + belbelbel.wins,
      dblearn,
      dblwin / dblsz, 
      prob,
      zscore);

   dblwin  = (double) (melmelbar.wins + melmelmel.wins);
   totwins += (melmelbar.wins + melmelmel.wins);
   dblearn = dblwin
      * (double) melmelmel.coins
      * coinval;
   totearn += dblearn;
   winning += dblearn;
   prob      = melmelbar.prob + melmelmel.prob;
   totprob  += prob;
   expect  = prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   sumx     += dblwin * prob;
   sumxsqd  += dblwin * dblwin * prob;
   sumchi   += diff * diff / expect;
   printf("Mel Mel Mel %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      melmelbar.wins + melmelmel.wins,
      dblearn,
      dblwin / dblsz, 
      prob,
      zscore);

   dblwin  = (double) barbarbar.wins;
   totwins += barbarbar.wins;
   dblearn = dblwin
      * (double) barbarbar.coins
      * coinval;
   totearn += dblearn;
   expect  = barbarbar.prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   winning += dblearn;
   totprob  += barbarbar.prob;
   sumx     += dblwin * barbarbar.prob;
   sumxsqd  += dblwin * dblwin * barbarbar.prob;
   sumchi   += diff * diff / expect;
   printf("Bar Bar Bar %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      barbarbar.wins,
      dblearn,
      dblwin / dblsz, 
      barbarbar.prob,
      zscore);

   dblwin  = (double) sevsevsev.wins;
   totwins += sevsevsev.wins;
   dblearn = dblwin
      * (double) sevsevsev.coins
      * coinval;
   totearn += dblearn;
   expect  = sevsevsev.prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   winning += dblearn;
   totprob  += sevsevsev.prob;
   sumx     += dblwin * sevsevsev.prob;
   sumxsqd  += dblwin * dblwin * sevsevsev.prob;
   sumchi   += diff * diff / expect;
   printf("Sev Sev Sev %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      sevsevsev.wins,
      dblearn,
      dblwin / dblsz, 
      sevsevsev.prob,
      zscore);

   other.coins = 0;
   other.prob  = 1.0 - totprob;
   dblwin  = (double) other.wins;
   totwins += other.wins;
   dblearn = 0.0;
   expect  = other.prob * dblsz;
   diff    = dblwin - expect;
   zscore  = diff / std_err;
   sumx     += dblwin * other.prob;
   sumxsqd  += dblwin * dblwin * other.prob;
   sumchi   += diff * diff / expect;
   printf("Other       %9d %10.2f "
      "%10.6f %10.6f %10.6f\n",
      other.wins,
      dblearn,
      dblwin / dblsz, 
      other.prob,
      zscore);

   printf("Totals      %9d %10.2f "
      "%10.6f %10.6f\n",
      totwins,
      winning,
      (double) totwins / dblsz, 
      totprob + other.prob);

   printf("\n");
   printf("                   Mean "
      "            "
      "Stdev "
      "       "
      "Z Score\n");
   mean     = sumx;
   variance = sumxsqd - (mean * mean);
   stdev    = sqrt(variance);
   zscore   = (mean - popmean) / std_err;
   printf("Population %16.6f %16.6f\n",
      popmean, popstdev);
   printf("Observed   %16.6f %16.6f %10.4f\n",
      mean, stdev, zscore);
   printf("\n");
   printf("Chi-square %f\n", sumchi);

   chirange(8,&lorange,&hirange);
   printf("Range at 95 percent "
      "is %10.6f to %10.6f\n",
      lorange, hirange);
   free(sd);
   return(0);
   } /* main */
