/*
serial.c Version 1.4.0 - Serial Test
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size categories\n", pgm);
   fprintf(stderr,"Where size is 1000 to 1000000\n");
   fprintf(stderr,"      categories is 10 to 100\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,k,size,cats,degf;
   double v;
   double mtx[100][100];
   double itm,rslt,mtxsize;
   double prob,expct,postblv,negtblv;
   if (argc != 3) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 1000 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   cats = atoi(*(argv+2));
   if (cats < 10 || cats > 100)
      {
      fprintf(stderr,"Invalid categories\n");
      putstx(*argv);
      } /* invalid cats */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"serial: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */

   for (i=0;i<cats;i++)
      {
      for (j=0;j<cats;j++)
         {
         mtx[i][j] = 0.0;
         } /* for right side */
      } /* for left side */
   k = 0;
   while (k++ < size)
      {
      i = rndnum(cats,sd);
      j = rndnum(cats,sd);
      mtx[i][j] += 1.0;
      } /* generate histogram */
   mtxsize = cats * cats;
   prob = 1.0 / mtxsize;
   expct = size * prob;
   degf = (cats - 1) * (cats - 1);
   chirange(degf,&negtblv,&postblv);
   v = 0.0;
   for (i=0;i<cats;i++)
      {
      for (j=0;j<cats;j++)
         {
         itm = mtx[i][j];
         v += (mtxsize * itm * itm);
         } /* for right side */
      } /* for left side */
   rslt = (double) v / size - size;
   printf("Chi-Square %f\n", rslt);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
