/*
sercorr.c Version 1.4.0 - Serial Correlation Test
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n", pgm);
   fprintf(stderr,"Where size is 10 - 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,size;
   double tmp,frst,prev;
   double sumx,sumpr,sumsq;
   double top,bot,correl;
   double mu,sigma;
   double from,to;
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 10 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"sercorr: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */
   frst = rndfrac(sd);
   prev = frst;
   sumpr = sumx = sumsq = 0.0;
   i = 1;
   while (i++ < size)
      {
      tmp = rndfrac(sd);
      sumpr += tmp * prev;
      sumx += tmp;
      sumsq += tmp * tmp;
      prev = tmp;
      } /* for each i in size */
   tmp = rndfrac(sd);
   sumpr += tmp * frst;
   top = (size * sumpr) - (sumx * sumx);
   bot = (size * sumsq) - (sumx * sumx);
   correl = top / bot;
   printf("%f\n", correl);
   mu = (double) -1.0 / (size - 1.0);
   sigma = (double) -mu
      * sqrt((size * (size - 3.0)) / (size + 1.0));
   from = mu - (2.0 * sigma);
   to = mu + (2.0 * sigma);
   printf("Range at 95 percent: %f  to  %f\n",
      from, to);
   return(0);
   } /* main */
