/*
realpat.c Version 1.4.0 - Generate Random Data Pattern
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* press 'r' to reset */
/* press 'q' to exit */

#include <stdio.h>
#include <math.h>
#include <curses.h>
#include "rnd.h"

#define SCRW 80.0
#define SCRH 24.0
#define ASCII 95.0

void initcrss()
   {
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"realpat: initcrss: "
	 "out of memory allocating sd\n");
      exit(1);
      } /* out of mem */
   initscr();
   cbreak();
   noecho();
   nonl();
   intrflush(stdscr,FALSE);
   nodelay(stdscr,TRUE);
   } /* initcrss */

int main()
   {
   int ch,x,y;
   initcrss();
   while(1)
      {
      y = (int) floor(rndfrac(sd) * SCRH);
      if (y == 23)
         x = (int) floor(rndfrac(sd) * (SCRW-1.0));
      else
         x = rndnum(SCRW,sd);
         x = (int) floor(rndfrac(sd) * SCRW);
      move(y,x);
      ch = (int) floor(rndfrac(sd) * ASCII) + 33;
      addch(ch);
      refresh();
      ch = getch();
      if (ch == 0x1b)    /* ESCAPE */
         break;
      if (ch == 'q')     /* quit   */
         break;
      if (ch == 'r')     /* reset  */
         {
         clear();
         refresh();
         } /* reset */
      }
   endwin();
   return(0);
   } /* main */
