#!/usr/bin/make

# poker.mak - Compile Program poker.c
# Version 1.4.0
# Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

OBJ=poker.o \
	chirange.o \
	rnd.o \
	rndnum.o \
	rndpwr.o \
	rndfrac.o \
	rndinit.o \
	getmd5.o \
	md5c.o

CC=gcc

CFLAGS=-c -Wall -O6

LDFLAGS=-lm

all:		$(OBJ) poker

poker:		$(OBJ)
	gcc -Wall -O6 $(OBJ) -o poker $(LDFLAGS)

poker.o:	poker.c
	gcc $(CFLAGS) poker.c

chirange.o:	chirange.c
	gcc $(CFLAGS) chirange.c

rnd.o:		rnd.s
	gcc $(CFLAGS) rnd.s

rndnum.o:	rndnum.s
	gcc $(CFLAGS) rndnum.s

rndpwr.o:	rndpwr.s
	gcc $(CFLAGS) rndpwr.s

rndfrac.o:	rndfrac.s
	gcc $(CFLAGS) rndfrac.s

rndinit.o:	rndinit.c
	gcc $(CFLAGS) rndinit.c

getmd5.o:	getmd5.c
	gcc $(CFLAGS) getmd5.c

md5c.o:		md5c.c
	gcc $(CFLAGS) md5c.c

clean:
	rm -f $(OBJ) poker
